/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.base.AbstractJoinPop;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.work.filter.RuntimeFilterDef;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

@JsonTypeName(value="hash-join")
@JsonIgnoreProperties(ignoreUnknown=true)
public class HashJoinPOP
extends AbstractJoinPop {
    public static final String OPERATOR_TYPE = "HASH_JOIN";
    private RuntimeFilterDef runtimeFilterDef;
    private final boolean isRowKeyJoin;
    private final int joinControl;
    @JsonProperty(value="subScanForRowKeyJoin")
    private SubScan subScanForRowKeyJoin;

    @JsonCreator
    public HashJoinPOP(@JsonProperty(value="left") PhysicalOperator left, @JsonProperty(value="right") PhysicalOperator right, @JsonProperty(value="conditions") List<JoinCondition> conditions, @JsonProperty(value="joinType") JoinRelType joinType, @JsonProperty(value="semiJoin") boolean semiJoin, @JsonProperty(value="runtimeFilterDef") RuntimeFilterDef runtimeFilterDef, @JsonProperty(value="isRowKeyJoin") boolean isRowKeyJoin, @JsonProperty(value="joinControl") int joinControl) {
        super(left, right, joinType, semiJoin, null, conditions);
        Preconditions.checkArgument(joinType != null, "Join type is missing for HashJoin Pop");
        this.runtimeFilterDef = runtimeFilterDef;
        this.isRowKeyJoin = isRowKeyJoin;
        this.subScanForRowKeyJoin = null;
        this.joinControl = joinControl;
    }

    @VisibleForTesting
    public HashJoinPOP(PhysicalOperator left, PhysicalOperator right, List<JoinCondition> conditions, JoinRelType joinType, RuntimeFilterDef runtimeFilterDef, boolean isRowKeyJoin, int joinControl) {
        this(left, right, conditions, joinType, false, runtimeFilterDef, isRowKeyJoin, joinControl);
    }

    @VisibleForTesting
    public HashJoinPOP(PhysicalOperator left, PhysicalOperator right, List<JoinCondition> conditions, JoinRelType joinType) {
        this(left, right, conditions, joinType, null, false, 0);
    }

    @VisibleForTesting
    public HashJoinPOP(PhysicalOperator left, PhysicalOperator right, List<JoinCondition> conditions, JoinRelType joinType, RuntimeFilterDef runtimeFilterDef) {
        this(left, right, conditions, joinType, runtimeFilterDef, false, 0);
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.size() == 2);
        HashJoinPOP newHashJoin = new HashJoinPOP(children.get(0), children.get(1), this.conditions, this.joinType, this.semiJoin, this.runtimeFilterDef, this.isRowKeyJoin, this.joinControl);
        newHashJoin.setMaxAllocation(this.getMaxAllocation());
        newHashJoin.setSubScanForRowKeyJoin(this.getSubScanForRowKeyJoin());
        return newHashJoin;
    }

    @JsonProperty(value="isRowKeyJoin")
    public boolean isRowKeyJoin() {
        return this.isRowKeyJoin;
    }

    @JsonProperty(value="joinControl")
    public int getJoinControl() {
        return this.joinControl;
    }

    @JsonProperty(value="subScanForRowKeyJoin")
    public SubScan getSubScanForRowKeyJoin() {
        return this.subScanForRowKeyJoin;
    }

    public void setSubScanForRowKeyJoin(SubScan subScan) {
        this.subScanForRowKeyJoin = subScan;
    }

    public HashJoinPOP flipIfRight() {
        if (this.joinType == JoinRelType.RIGHT) {
            ArrayList<JoinCondition> flippedConditions = Lists.newArrayList();
            for (JoinCondition c : this.conditions) {
                flippedConditions.add(c.flip());
            }
            return new HashJoinPOP(this.right, this.left, flippedConditions, JoinRelType.LEFT, this.semiJoin, this.runtimeFilterDef, this.isRowKeyJoin, this.joinControl);
        }
        return this;
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    @Override
    public void setMaxAllocation(long maxAllocation) {
        this.maxAllocation = maxAllocation;
    }

    @Override
    public boolean isBufferedOperator(QueryContext queryContext) {
        return queryContext == null || 1 < (int)queryContext.getOptions().getOption(ExecConstants.HASHJOIN_NUM_PARTITIONS_VALIDATOR);
    }

    public void setRuntimeFilterDef(RuntimeFilterDef runtimeFilterDef) {
        this.runtimeFilterDef = runtimeFilterDef;
    }

    public RuntimeFilterDef getRuntimeFilterDef() {
        return this.runtimeFilterDef;
    }
}

