/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.base.AbstractSingle;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.planner.physical.AggPrelBase;

@JsonTypeName(value="hash-aggregate")
public class HashAggregate
extends AbstractSingle {
    public static final String OPERATOR_TYPE = "HASH_AGGREGATE";
    private final AggPrelBase.OperatorPhase aggPhase;
    private final List<NamedExpression> groupByExprs;
    private final List<NamedExpression> aggrExprs;
    private final float cardinality;

    @JsonCreator
    public HashAggregate(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="phase") AggPrelBase.OperatorPhase aggPhase, @JsonProperty(value="keys") List<NamedExpression> groupByExprs, @JsonProperty(value="exprs") List<NamedExpression> aggrExprs, @JsonProperty(value="cardinality") float cardinality) {
        super(child);
        this.aggPhase = aggPhase;
        this.groupByExprs = groupByExprs;
        this.aggrExprs = aggrExprs;
        this.cardinality = cardinality;
    }

    public AggPrelBase.OperatorPhase getAggPhase() {
        return this.aggPhase;
    }

    public List<NamedExpression> getGroupByExprs() {
        return this.groupByExprs;
    }

    public List<NamedExpression> getAggrExprs() {
        return this.aggrExprs;
    }

    public double getCardinality() {
        return this.cardinality;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitHashAggregate(this, value);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        HashAggregate newHAG = new HashAggregate(child, this.aggPhase, this.groupByExprs, this.aggrExprs, this.cardinality);
        newHAG.setMaxAllocation(this.getMaxAllocation());
        return newHAG;
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    @Override
    public void setMaxAllocation(long maxAllocation) {
        this.maxAllocation = maxAllocation;
    }

    @Override
    public boolean isBufferedOperator(QueryContext queryContext) {
        return queryContext == null || 1 < (int)queryContext.getOptions().getOption(ExecConstants.HASHAGG_NUM_PARTITIONS_VALIDATOR);
    }

    public String toString() {
        return "HashAggregate[groupByExprs=" + this.groupByExprs + ", aggrExprs=" + this.aggrExprs + ", cardinality=" + this.cardinality + "]";
    }
}

