/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.Sort;

@JsonTypeName(value="external-sort")
public class ExternalSort
extends Sort {
    public static final long DEFAULT_SORT_ALLOCATION = 20000000L;
    public static final String OPERATOR_TYPE = "EXTERNAL_SORT";

    @JsonCreator
    public ExternalSort(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="orderings") List<Order.Ordering> orderings, @JsonProperty(value="reverse") boolean reverse) {
        super(child, orderings, reverse);
        this.initialAllocation = 20000000L;
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        ExternalSort newSort = new ExternalSort(child, this.orderings, this.reverse);
        newSort.setMaxAllocation(this.getMaxAllocation());
        return newSort;
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    @Override
    public void setMaxAllocation(long maxAllocation) {
        this.maxAllocation = maxAllocation;
    }

    @Override
    public boolean isBufferedOperator(QueryContext queryContext) {
        return true;
    }
}

