/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.MinorFragmentEndpoint;
import org.apache.drill.exec.physical.base.AbstractExchange;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.config.HashPartitionSender;
import org.apache.drill.exec.planner.fragment.ParallelizationInfo;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ArrayListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public abstract class AbstractDeMuxExchange
extends AbstractExchange {
    protected final LogicalExpression expr;
    protected Map<Integer, MinorFragmentEndpoint> receiverToSenderMapping;
    protected ArrayListMultimap<Integer, MinorFragmentEndpoint> senderToReceiversMapping;
    private boolean isSenderReceiverMappingCreated;

    public AbstractDeMuxExchange(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="expr") LogicalExpression expr) {
        super(child);
        this.expr = expr;
    }

    @JsonProperty(value="expr")
    public LogicalExpression getExpression() {
        return this.expr;
    }

    @Override
    public ParallelizationInfo getSenderParallelizationInfo(List<CoordinationProtos.DrillbitEndpoint> receiverFragmentEndpoints) {
        Preconditions.checkArgument(receiverFragmentEndpoints != null && receiverFragmentEndpoints.size() > 0, "Receiver fragment endpoint list should not be empty");
        ImmutableList<CoordinationProtos.DrillbitEndpoint> drillbitEndpoints = ImmutableSet.copyOf(receiverFragmentEndpoints).asList();
        ArrayList<EndpointAffinity> affinities = Lists.newArrayList();
        for (CoordinationProtos.DrillbitEndpoint ep : drillbitEndpoints) {
            affinities.add(new EndpointAffinity(ep, Double.POSITIVE_INFINITY));
        }
        return ParallelizationInfo.create(affinities.size(), affinities.size(), affinities);
    }

    @Override
    public ParallelizationInfo getReceiverParallelizationInfo(List<CoordinationProtos.DrillbitEndpoint> senderFragmentEndpoints) {
        return ParallelizationInfo.UNLIMITED_WIDTH_NO_ENDPOINT_AFFINITY;
    }

    @Override
    public Sender getSender(int minorFragmentId, PhysicalOperator child) {
        this.createSenderReceiverMapping();
        List receivers = this.senderToReceiversMapping.get((Object)minorFragmentId);
        if (receivers == null || receivers.size() <= 0) {
            throw new IllegalStateException(String.format("Failed to find receivers for sender [%d]", minorFragmentId));
        }
        return new HashPartitionSender(this.receiverMajorFragmentId, child, this.expr, receivers);
    }

    @Override
    public Exchange.ParallelizationDependency getParallelizationDependency() {
        return Exchange.ParallelizationDependency.SENDER_DEPENDS_ON_RECEIVER;
    }

    protected void createSenderReceiverMapping() {
        if (this.isSenderReceiverMappingCreated) {
            return;
        }
        this.senderToReceiversMapping = ArrayListMultimap.create();
        this.receiverToSenderMapping = Maps.newHashMap();
        ArrayListMultimap endpointReceiverList = ArrayListMultimap.create();
        int receiverFragmentId = 0;
        for (CoordinationProtos.DrillbitEndpoint receiverLocation : this.receiverLocations) {
            endpointReceiverList.put(receiverLocation, (Object)receiverFragmentId);
            ++receiverFragmentId;
        }
        int senderFragmentId = 0;
        for (CoordinationProtos.DrillbitEndpoint senderLocation : this.senderLocations) {
            List receiverMinorFragmentIds = endpointReceiverList.get(senderLocation);
            for (Integer receiverId : receiverMinorFragmentIds) {
                this.receiverToSenderMapping.put(receiverId, new MinorFragmentEndpoint(senderFragmentId, senderLocation));
                this.senderToReceiversMapping.put((Object)senderFragmentId, (Object)new MinorFragmentEndpoint(receiverId, (CoordinationProtos.DrillbitEndpoint)this.receiverLocations.get(receiverId)));
            }
            ++senderFragmentId;
        }
        this.isSenderReceiverMappingCreated = true;
    }
}

