/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.MinorFragmentEndpoint;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.record.VectorAccessible;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalOperatorUtil {
    private static final Logger logger = LoggerFactory.getLogger(PhysicalOperatorUtil.class);

    private PhysicalOperatorUtil() {
    }

    public static Set<Class<? extends PhysicalOperator>> getSubTypes(ScanResult classpathScan) {
        Set<Class<? extends PhysicalOperator>> ops = classpathScan.getImplementations(PhysicalOperator.class);
        logger.debug("Found {} physical operator classes: {}.", (Object)ops.size(), ops);
        return ops;
    }

    public static List<MinorFragmentEndpoint> getIndexOrderedEndpoints(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
        ArrayList<MinorFragmentEndpoint> destinations = new ArrayList<MinorFragmentEndpoint>();
        int minorFragmentId = 0;
        for (CoordinationProtos.DrillbitEndpoint endpoint : endpoints) {
            destinations.add(new MinorFragmentEndpoint(minorFragmentId, endpoint));
            ++minorFragmentId;
        }
        return destinations;
    }

    public static LogicalExpression materializeExpression(LogicalExpression expr, VectorAccessible incoming, FragmentContext context) {
        ErrorCollectorImpl collector = new ErrorCollectorImpl();
        LogicalExpression mle = ExpressionTreeMaterializer.materialize(expr, incoming, collector, context.getFunctionRegistry());
        collector.reportErrors(logger);
        return mle;
    }
}

