/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.drill.exec.physical.MinorFragmentEndpoint;
import org.apache.drill.exec.physical.base.AbstractSingle;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSender
extends AbstractSingle
implements Sender {
    static final Logger logger = LoggerFactory.getLogger(AbstractSender.class);
    protected final int oppositeMajorFragmentId;
    protected final List<MinorFragmentEndpoint> destinations;

    public AbstractSender(int oppositeMajorFragmentId, PhysicalOperator child, List<MinorFragmentEndpoint> destinations) {
        super(child);
        this.oppositeMajorFragmentId = oppositeMajorFragmentId;
        this.destinations = ImmutableList.copyOf(destinations);
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitSender(this, value);
    }

    @Override
    @JsonProperty(value="receiver-major-fragment")
    public int getOppositeMajorFragmentId() {
        return this.oppositeMajorFragmentId;
    }

    @Override
    @JsonProperty(value="destinations")
    public List<MinorFragmentEndpoint> getDestinations() {
        return this.destinations;
    }
}

