/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.base.Store;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.physical.base.Writer;
import org.apache.drill.exec.physical.config.BroadcastSender;
import org.apache.drill.exec.physical.config.Filter;
import org.apache.drill.exec.physical.config.FlattenPOP;
import org.apache.drill.exec.physical.config.HashAggregate;
import org.apache.drill.exec.physical.config.HashPartitionSender;
import org.apache.drill.exec.physical.config.HashToRandomExchange;
import org.apache.drill.exec.physical.config.IteratorValidator;
import org.apache.drill.exec.physical.config.LateralJoinPOP;
import org.apache.drill.exec.physical.config.Limit;
import org.apache.drill.exec.physical.config.MergingReceiverPOP;
import org.apache.drill.exec.physical.config.OrderedPartitionSender;
import org.apache.drill.exec.physical.config.ProducerConsumer;
import org.apache.drill.exec.physical.config.Project;
import org.apache.drill.exec.physical.config.RangePartitionSender;
import org.apache.drill.exec.physical.config.RowKeyJoinPOP;
import org.apache.drill.exec.physical.config.Screen;
import org.apache.drill.exec.physical.config.SetOp;
import org.apache.drill.exec.physical.config.SingleSender;
import org.apache.drill.exec.physical.config.Sort;
import org.apache.drill.exec.physical.config.StatisticsAggregate;
import org.apache.drill.exec.physical.config.StatisticsMerge;
import org.apache.drill.exec.physical.config.StreamingAggregate;
import org.apache.drill.exec.physical.config.TableModify;
import org.apache.drill.exec.physical.config.Trace;
import org.apache.drill.exec.physical.config.UnionAll;
import org.apache.drill.exec.physical.config.UnnestPOP;
import org.apache.drill.exec.physical.config.UnorderedReceiver;
import org.apache.drill.exec.physical.config.UnpivotMaps;
import org.apache.drill.exec.physical.config.Values;
import org.apache.drill.exec.physical.config.WindowPOP;

public abstract class AbstractPhysicalVisitor<T, X, E extends Throwable>
implements PhysicalVisitor<T, X, E> {
    @Override
    public T visitExchange(Exchange exchange, X value) throws E {
        return this.visitOp((PhysicalOperator)exchange, value);
    }

    @Override
    public T visitUnion(UnionAll union, X value) throws E {
        return this.visitOp((PhysicalOperator)union, value);
    }

    @Override
    public T visitSetOp(SetOp setOp, X value) throws E {
        return this.visitOp((PhysicalOperator)setOp, value);
    }

    @Override
    public T visitWriter(Writer writer, X value) throws E {
        return this.visitOp((PhysicalOperator)writer, value);
    }

    @Override
    public T visitFilter(Filter filter, X value) throws E {
        return this.visitOp((PhysicalOperator)filter, value);
    }

    @Override
    public T visitWindowFrame(WindowPOP windowFrame, X value) throws E {
        return this.visitOp((PhysicalOperator)windowFrame, value);
    }

    @Override
    public T visitProject(Project project, X value) throws E {
        return this.visitOp((PhysicalOperator)project, value);
    }

    @Override
    public T visitTrace(Trace trace, X value) throws E {
        return this.visitOp((PhysicalOperator)trace, value);
    }

    @Override
    public T visitSort(Sort sort, X value) throws E {
        return this.visitOp((PhysicalOperator)sort, value);
    }

    @Override
    public T visitLimit(Limit limit, X value) throws E {
        return this.visitOp((PhysicalOperator)limit, value);
    }

    @Override
    public T visitStreamingAggregate(StreamingAggregate agg, X value) throws E {
        return this.visitOp((PhysicalOperator)agg, value);
    }

    @Override
    public T visitStatisticsAggregate(StatisticsAggregate agg, X value) throws E {
        return this.visitOp((PhysicalOperator)agg, value);
    }

    @Override
    public T visitStatisticsMerge(StatisticsMerge agg, X value) throws E {
        return this.visitOp((PhysicalOperator)agg, value);
    }

    @Override
    public T visitHashAggregate(HashAggregate agg, X value) throws E {
        return this.visitOp((PhysicalOperator)agg, value);
    }

    @Override
    public T visitSender(Sender sender, X value) throws E {
        return this.visitOp((PhysicalOperator)sender, value);
    }

    @Override
    public T visitFlatten(FlattenPOP flatten, X value) throws E {
        return this.visitOp((PhysicalOperator)flatten, value);
    }

    @Override
    public T visitReceiver(Receiver receiver, X value) throws E {
        return this.visitOp((PhysicalOperator)receiver, value);
    }

    @Override
    public T visitGroupScan(GroupScan groupScan, X value) throws E {
        return this.visitOp((PhysicalOperator)groupScan, value);
    }

    @Override
    public T visitSubScan(SubScan subScan, X value) throws E {
        return this.visitOp((PhysicalOperator)subScan, value);
    }

    @Override
    public T visitStore(Store store, X value) throws E {
        return this.visitOp((PhysicalOperator)store, value);
    }

    public T visitChildren(PhysicalOperator op, X value) throws E {
        for (PhysicalOperator child : op) {
            child.accept(this, value);
        }
        return null;
    }

    @Override
    public T visitRowKeyJoin(RowKeyJoinPOP join, X value) throws E {
        return this.visitOp((PhysicalOperator)join, value);
    }

    @Override
    public T visitHashPartitionSender(HashPartitionSender op, X value) throws E {
        return this.visitSender((Sender)op, value);
    }

    @Override
    public T visitOrderedPartitionSender(OrderedPartitionSender op, X value) throws E {
        return this.visitSender((Sender)op, value);
    }

    @Override
    public T visitUnorderedReceiver(UnorderedReceiver op, X value) throws E {
        return this.visitReceiver((Receiver)op, value);
    }

    @Override
    public T visitMergingReceiver(MergingReceiverPOP op, X value) throws E {
        return this.visitReceiver((Receiver)op, value);
    }

    @Override
    public T visitHashPartitionSender(HashToRandomExchange op, X value) throws E {
        return this.visitExchange((Exchange)op, value);
    }

    @Override
    public T visitRangePartitionSender(RangePartitionSender op, X value) throws E {
        return this.visitSender((Sender)op, value);
    }

    @Override
    public T visitBroadcastSender(BroadcastSender op, X value) throws E {
        return this.visitSender((Sender)op, value);
    }

    @Override
    public T visitScreen(Screen op, X value) throws E {
        return this.visitStore((Store)op, value);
    }

    @Override
    public T visitSingleSender(SingleSender op, X value) throws E {
        return this.visitSender((Sender)op, value);
    }

    @Override
    public T visitProducerConsumer(ProducerConsumer op, X value) throws E {
        return this.visitOp((PhysicalOperator)op, value);
    }

    @Override
    public T visitUnnest(UnnestPOP unnest, X value) throws E {
        return this.visitOp((PhysicalOperator)unnest, value);
    }

    @Override
    public T visitLateralJoin(LateralJoinPOP lateralJoinPOP, X value) throws E {
        return this.visitOp((PhysicalOperator)lateralJoinPOP, value);
    }

    @Override
    public T visitIteratorValidator(IteratorValidator op, X value) throws E {
        return this.visitOp((PhysicalOperator)op, value);
    }

    @Override
    public T visitValues(Values op, X value) throws E {
        return this.visitOp((PhysicalOperator)op, value);
    }

    @Override
    public T visitUnpivot(UnpivotMaps op, X value) throws E {
        return this.visitOp((PhysicalOperator)op, value);
    }

    @Override
    public T visitTableModify(TableModify op, X value) throws E {
        return this.visitOp((PhysicalOperator)op, value);
    }

    @Override
    public T visitOp(PhysicalOperator op, X value) throws E {
        throw new UnsupportedOperationException(String.format("PhysicalVisitor of type %s does not support PhysicalOperator type %s.", this.getClass().getCanonicalName(), op.getClass().getCanonicalName()));
    }
}

