/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import java.util.Iterator;
import java.util.List;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterators;

public abstract class AbstractJoinPop
extends AbstractBase {
    protected final PhysicalOperator left;
    protected final PhysicalOperator right;
    protected final JoinRelType joinType;
    protected final boolean semiJoin;
    protected final LogicalExpression condition;
    protected final List<JoinCondition> conditions;

    public AbstractJoinPop(PhysicalOperator leftOp, PhysicalOperator rightOp, JoinRelType joinType, boolean semiJoin, LogicalExpression joinCondition, List<JoinCondition> joinConditions) {
        this.left = leftOp;
        this.right = rightOp;
        this.joinType = joinType;
        this.semiJoin = semiJoin;
        this.condition = joinCondition;
        this.conditions = joinConditions;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitOp(this, value);
    }

    @Override
    public Iterator<PhysicalOperator> iterator() {
        return Iterators.forArray(this.left, this.right);
    }

    public PhysicalOperator getLeft() {
        return this.left;
    }

    public PhysicalOperator getRight() {
        return this.right;
    }

    public JoinRelType getJoinType() {
        return this.joinType;
    }

    public boolean isSemiJoin() {
        return this.semiJoin;
    }

    public LogicalExpression getCondition() {
        return this.condition;
    }

    public List<JoinCondition> getConditions() {
        return this.conditions;
    }
}

