/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.ExpressionStringBuilder;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.compile.sig.ConstantExpressionIdentifier;
import org.apache.drill.exec.exception.MetadataException;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.FilterBuilder;
import org.apache.drill.exec.expr.FilterPredicate;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.expr.fn.FunctionLookupContext;
import org.apache.drill.exec.expr.stat.RowsMatch;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.metastore.analyze.FileMetadataInfoCollector;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.ops.UdfUtilities;
import org.apache.drill.exec.physical.base.AbstractFileGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.impl.scan.v3.FixedReceiver;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.parquet.FilterEvaluatorUtils;
import org.apache.drill.exec.store.parquet.ParquetTableMetadataUtils;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.metastore.metadata.BaseMetadata;
import org.apache.drill.metastore.metadata.FileMetadata;
import org.apache.drill.metastore.metadata.LocationProvider;
import org.apache.drill.metastore.metadata.Metadata;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.NonInterestingColumnsMetadata;
import org.apache.drill.metastore.metadata.PartitionMetadata;
import org.apache.drill.metastore.metadata.SegmentMetadata;
import org.apache.drill.metastore.metadata.TableMetadata;
import org.apache.drill.metastore.metadata.TableMetadataProvider;
import org.apache.drill.metastore.metadata.TableMetadataProviderBuilder;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.drill.metastore.util.SchemaPathUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGroupScanWithMetadata<P extends TableMetadataProvider>
extends AbstractFileGroupScan {
    static final Logger logger = LoggerFactory.getLogger(AbstractGroupScanWithMetadata.class);
    protected P metadataProvider;
    protected TableMetadata tableMetadata;
    protected List<PartitionMetadata> partitions;
    protected Map<Path, SegmentMetadata> segments;
    protected NonInterestingColumnsMetadata nonInterestingColumnsMetadata;
    protected List<SchemaPath> partitionColumns;
    protected LogicalExpression filter;
    protected List<SchemaPath> columns;
    protected Map<Path, FileMetadata> files;
    protected Set<Path> fileSet;
    protected boolean matchAllMetadata;
    protected boolean usedMetastore;
    protected int limit = -1;

    protected AbstractGroupScanWithMetadata(String userName, List<SchemaPath> columns, LogicalExpression filter) {
        super(userName);
        this.columns = columns;
        this.filter = filter;
    }

    protected AbstractGroupScanWithMetadata(AbstractGroupScanWithMetadata<P> that) {
        super(that.getUserName());
        this.columns = that.columns;
        this.filter = that.filter;
        this.matchAllMetadata = that.matchAllMetadata;
        this.metadataProvider = that.metadataProvider;
        this.tableMetadata = that.tableMetadata;
        this.partitionColumns = that.partitionColumns;
        this.partitions = that.partitions;
        this.segments = that.segments;
        this.files = that.files;
        this.usedMetastore = that.usedMetastore;
        this.nonInterestingColumnsMetadata = that.nonInterestingColumnsMetadata;
        this.fileSet = that.fileSet == null ? null : new HashSet<Path>(that.fileSet);
        this.limit = that.limit;
    }

    @Override
    @JsonProperty(value="columns")
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @Override
    public Collection<Path> getFiles() {
        return this.fileSet;
    }

    @Override
    public boolean hasFiles() {
        return true;
    }

    @JsonProperty(value="limit")
    public int getLimit() {
        return this.limit;
    }

    @JsonIgnore
    public boolean isMatchAllMetadata() {
        return this.matchAllMetadata;
    }

    @Override
    public long getColumnValueCount(SchemaPath column) {
        long tableRowCount;
        ColumnStatistics<?> nonInterestingColStats;
        ColumnStatistics<?> columnStats = this.getTableMetadata().getColumnStatistics(column);
        ColumnStatistics<?> columnStatistics = nonInterestingColStats = columnStats == null ? this.getNonInterestingColumnsMetadata().getColumnStatistics(column) : null;
        if (columnStats != null) {
            tableRowCount = TableStatisticsKind.ROW_COUNT.getValue(this.getTableMetadata());
        } else if (nonInterestingColStats != null) {
            tableRowCount = TableStatisticsKind.ROW_COUNT.getValue(this.getNonInterestingColumnsMetadata());
            columnStats = nonInterestingColStats;
        } else {
            if (this.hasNestedStatsForColumn(column, this.getTableMetadata()) || this.hasNestedStatsForColumn(column, this.getNonInterestingColumnsMetadata())) {
                return -1L;
            }
            return 0L;
        }
        Long nulls = ColumnStatisticsKind.NULLS_COUNT.getFrom(columnStats);
        if (nulls == null || -1L == nulls || -1L == tableRowCount) {
            return -1L;
        }
        return tableRowCount - nulls;
    }

    private boolean hasNestedStatsForColumn(SchemaPath column, Metadata metadata) {
        return metadata.getColumnsStatistics().keySet().stream().anyMatch(path -> path.contains(column));
    }

    @Override
    public String getDigest() {
        return this.toString();
    }

    @Override
    public ScanStats getScanStats() {
        int columnCount = this.columns == null ? 20 : this.columns.size();
        double rowCount = TableStatisticsKind.ROW_COUNT.getValue(this.getTableMetadata()).longValue();
        ScanStats scanStats = new ScanStats(ScanStats.GroupScanProperty.EXACT_ROW_COUNT, rowCount, 1.0, rowCount * (double)columnCount);
        logger.trace("Drill parquet scan statistics: {}", (Object)scanStats);
        return scanStats;
    }

    @Override
    @JsonProperty(value="filter")
    public LogicalExpression getFilter() {
        return this.filter;
    }

    public P getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setFilter(LogicalExpression filter) {
        this.filter = filter;
    }

    public void setFilterForRuntime(LogicalExpression filterExpr, OptimizerRulesContext optimizerContext) {
        OptionManager options = optimizerContext.getPlannerSettings().getOptions();
        boolean skipRuntimePruning = options.getBoolean("exec.storage.skip_runtime_rowgroup_pruning");
        if (!skipRuntimePruning) {
            this.setFilter(filterExpr);
        }
    }

    @Override
    public AbstractGroupScanWithMetadata<?> applyFilter(LogicalExpression filterExpr, UdfUtilities udfUtilities, FunctionImplementationRegistry functionImplementationRegistry, OptionManager optionManager) {
        FilterPredicate<?> filterPredicate = this.getFilterPredicate(filterExpr, udfUtilities, functionImplementationRegistry, optionManager, true);
        if (filterPredicate == null) {
            logger.debug("FilterPredicate cannot be built.");
            return null;
        }
        Object filteredMetadata = ((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)this.getFilterer().filterExpression(filterExpr)).schema(this.tableMetadata.getSchema())).context(functionImplementationRegistry)).udfUtilities(udfUtilities)).getFiltered(optionManager, filterPredicate);
        if (this.isGroupScanFullyMatchesFilter((GroupScanWithMetadataFilterer<?>)filteredMetadata)) {
            logger.debug("applyFilter() does not have any pruning since GroupScan fully matches filter");
            this.matchAllMetadata = ((GroupScanWithMetadataFilterer)filteredMetadata).isMatchAllMetadata();
            return null;
        }
        if (this.isAllDataPruned((GroupScanWithMetadataFilterer<?>)filteredMetadata)) {
            if (this.getFilesMetadata().size() == 1) {
                return null;
            }
            logger.debug("All files have been filtered out. Add back one to get schema from scanner");
            Map<Path, FileMetadata> filesMap = this.getNextOrEmpty(this.getFilesMetadata().values()).stream().collect(Collectors.toMap(FileMetadata::getPath, Function.identity()));
            Map<Path, SegmentMetadata> segmentsMap = this.getNextOrEmpty(this.getSegmentsMetadata().values()).stream().collect(Collectors.toMap(SegmentMetadata::getPath, Function.identity()));
            ((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)filteredMetadata).table(this.getTableMetadata())).segments(segmentsMap)).partitions(this.getNextOrEmpty(this.getPartitionsMetadata()))).files(filesMap)).nonInterestingColumns(this.getNonInterestingColumnsMetadata())).matching(false);
        }
        return ((GroupScanWithMetadataFilterer)filteredMetadata).build();
    }

    protected boolean isAllDataPruned(GroupScanWithMetadataFilterer<?> filteredMetadata) {
        return !filteredMetadata.isMatchAllMetadata() && filteredMetadata.getTableMetadata() == null && this.getTableMetadata() != null || filteredMetadata.getSegments().isEmpty() && !this.getSegmentsMetadata().isEmpty() || filteredMetadata.getPartitions().isEmpty() && !this.getPartitionsMetadata().isEmpty() || filteredMetadata.getFiles().isEmpty() && !this.getFilesMetadata().isEmpty();
    }

    protected boolean isGroupScanFullyMatchesFilter(GroupScanWithMetadataFilterer<?> filteredMetadata) {
        if (MapUtils.isNotEmpty(this.getFilesMetadata())) {
            return this.getFilesMetadata().size() == filteredMetadata.getFiles().size();
        }
        if (CollectionUtils.isNotEmpty(this.getPartitionsMetadata())) {
            return this.getPartitionsMetadata().size() == filteredMetadata.getPartitions().size();
        }
        if (MapUtils.isNotEmpty(this.getSegmentsMetadata())) {
            return this.getSegmentsMetadata().size() == filteredMetadata.getSegments().size();
        }
        return this.getTableMetadata() != null;
    }

    protected <T> List<T> getNextOrEmpty(Collection<T> inputList) {
        return CollectionUtils.isNotEmpty(inputList) ? Collections.singletonList(inputList.iterator().next()) : Collections.emptyList();
    }

    protected abstract GroupScanWithMetadataFilterer<?> getFilterer();

    public FilterPredicate<?> getFilterPredicate(LogicalExpression filterExpr, UdfUtilities udfUtilities, FunctionLookupContext functionImplementationRegistry, OptionManager optionManager, boolean omitUnsupportedExprs) {
        return AbstractGroupScanWithMetadata.getFilterPredicate(filterExpr, udfUtilities, functionImplementationRegistry, optionManager, omitUnsupportedExprs, this.supportsFileImplicitColumns(), this.getTableMetadata().getSchema());
    }

    public static FilterPredicate<?> getFilterPredicate(LogicalExpression filterExpr, UdfUtilities udfUtilities, FunctionLookupContext functionImplementationRegistry, OptionManager optionManager, boolean omitUnsupportedExprs, boolean supportsFileImplicitColumns, TupleMetadata schema) {
        TupleMetadata types = schema.copy();
        Set<SchemaPath> schemaPathsInExpr = filterExpr.accept(FilterEvaluatorUtils.FieldReferenceFinder.INSTANCE, null);
        if (supportsFileImplicitColumns) {
            for (SchemaPath schemaPath : schemaPathsInExpr) {
                if (!AbstractGroupScanWithMetadata.isImplicitOrPartCol(schemaPath, optionManager) || SchemaPathUtils.getColumnMetadata(schemaPath, types) != null) continue;
                types.add(MaterializedField.create(schemaPath.getRootSegmentPath(), Types.required(TypeProtos.MinorType.VARCHAR)));
            }
        }
        ErrorCollectorImpl errorCollector = new ErrorCollectorImpl();
        LogicalExpression materializedFilter = ExpressionTreeMaterializer.materializeFilterExpr(filterExpr, types, errorCollector, functionImplementationRegistry);
        if (errorCollector.hasErrors()) {
            logger.error("{} error(s) encountered when materialize filter expression : {}", (Object)errorCollector.getErrorCount(), (Object)errorCollector.toErrorString());
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("materializedFilter : {}", (Object)ExpressionStringBuilder.toString(materializedFilter));
        }
        Set<LogicalExpression> constantBoundaries = ConstantExpressionIdentifier.getConstantExpressionSet(materializedFilter);
        return FilterBuilder.buildFilterPredicate(materializedFilter, constantBoundaries, udfUtilities, omitUnsupportedExprs);
    }

    @JsonProperty
    public TupleMetadata getSchema() {
        TupleSchema tuple = new TupleSchema();
        for (ColumnMetadata md : this.getTableMetadata().getSchema()) {
            tuple.addColumn(md.copy());
        }
        return tuple;
    }

    @Override
    public boolean supportsLimitPushdown() {
        return true;
    }

    @Override
    public GroupScan applyLimit(int maxRecords) {
        long tableRowCount;
        maxRecords = Math.max(maxRecords, 0);
        GroupScanWithMetadataFilterer<?> prunedMetadata = this.getFilterer();
        if (this.getTableMetadata() != null && ((tableRowCount = TableStatisticsKind.ROW_COUNT.getValue(this.getTableMetadata()).longValue()) == -1L || tableRowCount <= (long)maxRecords)) {
            logger.debug("limit push down does not apply, since total number of rows [{}] is less or equal to the required [{}].", (Object)tableRowCount, (Object)maxRecords);
            if (this.limit != maxRecords) {
                prunedMetadata.limit(maxRecords);
                return prunedMetadata.build();
            }
            return null;
        }
        List<FileMetadata> qualifiedFiles = this.limitMetadata(this.getFilesMetadata().values(), maxRecords);
        if (qualifiedFiles == null || qualifiedFiles.size() == this.getFilesMetadata().size()) {
            logger.debug("limit push down does not apply, since number of files was not reduced.");
            if (this.limit != maxRecords) {
                prunedMetadata.limit(maxRecords);
                return prunedMetadata.build();
            }
            return null;
        }
        Map<Path, FileMetadata> filesMap = qualifiedFiles.stream().collect(Collectors.toMap(FileMetadata::getPath, Function.identity()));
        return ((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)((GroupScanWithMetadataFilterer)prunedMetadata.table(this.getTableMetadata())).segments(this.getSegmentsMetadata())).partitions(this.getPartitionsMetadata())).files(filesMap)).limit(maxRecords)).nonInterestingColumns(this.getNonInterestingColumnsMetadata())).matching(this.matchAllMetadata)).build();
    }

    protected static <T extends BaseMetadata> Map<Path, T> pruneForPartitions(Map<Path, T> metadataToPrune, List<PartitionMetadata> filteredPartitionMetadata) {
        LinkedHashMap prunedFiles = new LinkedHashMap();
        if (metadataToPrune != null) {
            metadataToPrune.forEach((? super K path, ? super V metadata) -> {
                for (PartitionMetadata filteredPartition : filteredPartitionMetadata) {
                    if (!filteredPartition.getLocations().contains(path)) continue;
                    prunedFiles.put(path, metadata);
                    break;
                }
            });
        }
        return prunedFiles;
    }

    protected <T extends BaseMetadata> List<T> limitMetadata(Collection<T> metadataList, int maxRecords) {
        ArrayList<BaseMetadata> qualifiedMetadata = new ArrayList<BaseMetadata>();
        long currentRowCount = 0L;
        for (BaseMetadata metadata : metadataList) {
            long rowCount = TableStatisticsKind.ROW_COUNT.getValue(metadata);
            if (rowCount == -1L) {
                return null;
            }
            if (currentRowCount + rowCount <= (long)maxRecords) {
                currentRowCount += rowCount;
                qualifiedMetadata.add(metadata);
                continue;
            }
            if (currentRowCount >= (long)maxRecords) break;
            qualifiedMetadata.add(metadata);
            break;
        }
        return qualifiedMetadata;
    }

    @Override
    public List<SchemaPath> getPartitionColumns() {
        if (this.partitionColumns == null) {
            this.partitionColumns = this.metadataProvider.getPartitionColumns();
            if (this.partitionColumns == null) {
                this.partitionColumns = new ArrayList<SchemaPath>();
            }
        }
        return this.partitionColumns;
    }

    @JsonIgnore
    public TypeProtos.MajorType getTypeForColumn(SchemaPath schemaPath) {
        ColumnMetadata columnMetadata = SchemaPathUtils.getColumnMetadata(schemaPath, this.getTableMetadata().getSchema());
        return columnMetadata != null ? columnMetadata.majorType() : null;
    }

    @JsonIgnore
    public <T> T getPartitionValue(Path path, SchemaPath column, Class<T> clazz) {
        return this.getPartitionsMetadata().stream().filter(partition -> partition.getColumn().equals(column) && partition.getLocations().contains(path)).findAny().map(metadata -> clazz.cast(metadata.getColumnsStatistics().get(column).get(ColumnStatisticsKind.MAX_VALUE))).orElse(null);
    }

    @JsonIgnore
    public Set<Path> getFileSet() {
        return this.fileSet;
    }

    @Override
    public void modifyFileSelection(FileSelection selection) {
        this.fileSet = new HashSet<Path>(selection.getFiles());
    }

    protected void init() throws IOException {
        if (this.fileSet == null && this.getFilesMetadata() != null) {
            this.fileSet = this.getFilesMetadata().keySet();
        }
    }

    protected String getFilterString() {
        return this.filter == null || this.filter.equals(ValueExpressions.BooleanExpression.TRUE) ? "" : ExpressionStringBuilder.toString(this.filter);
    }

    protected abstract boolean supportsFileImplicitColumns();

    protected abstract List<String> getPartitionValues(LocationProvider var1);

    public static boolean isImplicitOrPartCol(SchemaPath schemaPath, OptionManager optionManager) {
        Set<String> implicitColNames = ColumnExplorer.initImplicitFileColumns(optionManager).keySet();
        return ColumnExplorer.isPartitionColumn(optionManager, schemaPath) || implicitColNames.contains(schemaPath.getRootSegmentPath());
    }

    @JsonIgnore
    public Map<Path, FileMetadata> getFilesMetadata() {
        if (this.files == null) {
            this.files = this.metadataProvider.getFilesMetadataMap();
        }
        return this.files;
    }

    @Override
    public TableMetadata getTableMetadata() {
        if (this.tableMetadata == null) {
            this.tableMetadata = this.metadataProvider.getTableMetadata();
        }
        return this.tableMetadata;
    }

    @JsonIgnore
    public List<PartitionMetadata> getPartitionsMetadata() {
        if (this.partitions == null) {
            this.partitions = this.metadataProvider.getPartitionsMetadata();
        }
        return this.partitions;
    }

    @JsonIgnore
    public Map<Path, SegmentMetadata> getSegmentsMetadata() {
        if (this.segments == null) {
            this.segments = this.metadataProvider.getSegmentsMetadataMap();
        }
        return this.segments;
    }

    @Override
    public boolean usedMetastore() {
        return this.usedMetastore;
    }

    @JsonIgnore
    public NonInterestingColumnsMetadata getNonInterestingColumnsMetadata() {
        if (this.nonInterestingColumnsMetadata == null) {
            this.nonInterestingColumnsMetadata = this.metadataProvider.getNonInterestingColumnsMetadata();
        }
        return this.nonInterestingColumnsMetadata;
    }

    protected abstract TableMetadataProviderBuilder tableMetadataProviderBuilder(MetadataProviderManager var1);

    protected abstract TableMetadataProviderBuilder defaultTableMetadataProviderBuilder(MetadataProviderManager var1);

    protected void checkMetadataConsistency(FileSelection selection, Configuration fsConf) throws IOException {
        if (this.metadataProvider.checkMetadataVersion()) {
            DrillFileSystem fileSystem = ImpersonationUtil.createFileSystem(ImpersonationUtil.resolveUserName(this.getUserName()), fsConf);
            List<FileStatus> fileStatuses = FileMetadataInfoCollector.getFileStatuses(selection, fileSystem);
            long lastModifiedTime = this.metadataProvider.getTableMetadata().getLastModifiedTime();
            HashSet<Path> removedFiles = new HashSet<Path>(this.metadataProvider.getFilesMetadataMap().keySet());
            HashSet<Path> newFiles = new HashSet<Path>();
            boolean isChanged = false;
            for (FileStatus fileStatus : fileStatuses) {
                if (!removedFiles.remove(Path.getPathWithoutSchemeAndAuthority((Path)fileStatus.getPath()))) {
                    newFiles.add(fileStatus.getPath());
                }
                if (fileStatus.getModificationTime() <= lastModifiedTime) continue;
                isChanged = true;
                break;
            }
            if (isChanged || !removedFiles.isEmpty() || !newFiles.isEmpty()) {
                throw MetadataException.of(MetadataException.MetadataExceptionType.OUTDATED_METADATA);
            }
        }
    }

    protected static abstract class GroupScanWithMetadataFilterer<B extends GroupScanWithMetadataFilterer<B>> {
        protected final AbstractGroupScanWithMetadata<? extends TableMetadataProvider> source;
        protected boolean matchAllMetadata;
        protected TableMetadata tableMetadata;
        protected List<PartitionMetadata> partitions = Collections.emptyList();
        protected Map<Path, SegmentMetadata> segments = Collections.emptyMap();
        protected Map<Path, FileMetadata> files = Collections.emptyMap();
        protected NonInterestingColumnsMetadata nonInterestingColumnsMetadata;
        protected LogicalExpression filterExpression;
        protected TupleMetadata tableSchema;
        protected UdfUtilities udfUtilities;
        protected FunctionLookupContext context;
        protected int limit = -1;
        protected MetadataType overflowLevel = MetadataType.NONE;

        public GroupScanWithMetadataFilterer(AbstractGroupScanWithMetadata<?> source) {
            this.source = source;
        }

        public abstract AbstractGroupScanWithMetadata<?> build();

        public B table(TableMetadata tableMetadata) {
            this.tableMetadata = tableMetadata;
            return this.self();
        }

        public B partitions(List<PartitionMetadata> partitions) {
            this.partitions = partitions;
            return this.self();
        }

        public B segments(Map<Path, SegmentMetadata> segments) {
            this.segments = segments;
            return this.self();
        }

        public B nonInterestingColumns(NonInterestingColumnsMetadata nonInterestingColumns) {
            this.nonInterestingColumnsMetadata = nonInterestingColumns;
            return this.self();
        }

        public B files(Map<Path, FileMetadata> files) {
            this.files = files;
            return this.self();
        }

        public B limit(int maxRecords) {
            this.limit = maxRecords;
            return this.self();
        }

        public B matching(boolean matchAllMetadata) {
            this.matchAllMetadata = matchAllMetadata;
            return this.self();
        }

        public B overflow(MetadataType overflowLevel) {
            this.overflowLevel = overflowLevel;
            return this.self();
        }

        public B filterExpression(LogicalExpression filterExpression) {
            this.filterExpression = filterExpression;
            return this.self();
        }

        public B schema(TupleMetadata tableSchema) {
            this.tableSchema = tableSchema;
            return this.self();
        }

        public B udfUtilities(UdfUtilities udfUtilities) {
            this.udfUtilities = udfUtilities;
            return this.self();
        }

        public B context(FunctionLookupContext context) {
            this.context = context;
            return this.self();
        }

        public boolean isMatchAllMetadata() {
            return this.matchAllMetadata;
        }

        public TableMetadata getTableMetadata() {
            return this.tableMetadata;
        }

        public List<PartitionMetadata> getPartitions() {
            return this.partitions;
        }

        public Map<Path, SegmentMetadata> getSegments() {
            return this.segments;
        }

        public Map<Path, FileMetadata> getFiles() {
            return this.files;
        }

        public MetadataType getOverflowLevel() {
            return this.overflowLevel;
        }

        protected B getFiltered(OptionManager optionManager, FilterPredicate<?> filterPredicate) {
            Objects.requireNonNull(this.filterExpression, "filterExpression was not set");
            Objects.requireNonNull(this.tableSchema, "tableSchema was not set");
            Objects.requireNonNull(this.udfUtilities, "udfUtilities were not set");
            Objects.requireNonNull(this.context, "context was not set");
            Set<SchemaPath> schemaPathsInExpr = this.filterExpression.accept(FilterEvaluatorUtils.FieldReferenceFinder.INSTANCE, null);
            if (this.source.getTableMetadata() != null) {
                this.filterTableMetadata(filterPredicate, schemaPathsInExpr);
            }
            if (this.source.getSegmentsMetadata() != null) {
                this.filterSegmentMetadata(optionManager, filterPredicate, schemaPathsInExpr);
            }
            if (this.source.getPartitionsMetadata() != null) {
                this.filterPartitionMetadata(optionManager, filterPredicate, schemaPathsInExpr);
            }
            if (this.source.getFilesMetadata() != null) {
                this.filterFileMetadata(optionManager, filterPredicate, schemaPathsInExpr);
            }
            return this.self();
        }

        protected void filterTableMetadata(FilterPredicate<?> filterPredicate, Set<SchemaPath> schemaPathsInExpr) {
            this.matchAllMetadata = true;
            List<TableMetadata> filteredTableMetadata = this.filterAndGetMetadata(schemaPathsInExpr, Collections.singletonList(this.source.getTableMetadata()), filterPredicate, null);
            if (CollectionUtils.isNotEmpty(filteredTableMetadata)) {
                this.tableMetadata = filteredTableMetadata.get(0);
            }
        }

        protected void filterSegmentMetadata(OptionManager optionManager, FilterPredicate<?> filterPredicate, Set<SchemaPath> schemaPathsInExpr) {
            if (!this.matchAllMetadata) {
                if (!this.source.getSegmentsMetadata().isEmpty()) {
                    if ((long)this.source.getSegmentsMetadata().size() <= optionManager.getOption(PlannerSettings.PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING_THRESHOLD)) {
                        this.matchAllMetadata = true;
                        this.segments = this.filterAndGetMetadata(schemaPathsInExpr, this.source.getSegmentsMetadata().values(), filterPredicate, optionManager).stream().collect(Collectors.toMap(SegmentMetadata::getPath, Function.identity(), (first, second) -> second));
                    } else {
                        this.overflowLevel = MetadataType.SEGMENT;
                    }
                }
            } else {
                this.segments = this.source.getSegmentsMetadata();
            }
        }

        protected void filterPartitionMetadata(OptionManager optionManager, FilterPredicate<?> filterPredicate, Set<SchemaPath> schemaPathsInExpr) {
            List<PartitionMetadata> prunedPartitions = !this.source.getSegmentsMetadata().isEmpty() && this.source.getSegmentsMetadata().size() > this.getSegments().size() ? this.pruneForSegments(this.source.getPartitionsMetadata(), this.getSegments()) : this.source.getPartitionsMetadata();
            if (this.isMatchAllMetadata()) {
                this.partitions = prunedPartitions;
                return;
            }
            if (!this.source.getPartitionsMetadata().isEmpty()) {
                if ((long)this.source.getPartitionsMetadata().size() <= optionManager.getOption(PlannerSettings.PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING_THRESHOLD)) {
                    this.matchAllMetadata = true;
                    this.partitions = this.filterAndGetMetadata(schemaPathsInExpr, prunedPartitions, filterPredicate, optionManager);
                } else {
                    this.overflowLevel = MetadataType.PARTITION;
                }
            }
        }

        protected void filterFileMetadata(OptionManager optionManager, FilterPredicate<?> filterPredicate, Set<SchemaPath> schemaPathsInExpr) {
            Map<Path, FileMetadata> prunedFiles = !this.source.getPartitionsMetadata().isEmpty() && this.source.getPartitionsMetadata().size() > this.getPartitions().size() ? AbstractGroupScanWithMetadata.pruneForPartitions(this.source.getFilesMetadata(), this.getPartitions()) : (!this.source.getSegmentsMetadata().isEmpty() && this.source.getSegmentsMetadata().size() > this.getSegments().size() ? GroupScanWithMetadataFilterer.pruneForSegments(this.source.getFilesMetadata(), this.getSegments()) : this.source.getFilesMetadata());
            if (this.isMatchAllMetadata()) {
                this.files = prunedFiles;
                return;
            }
            if ((long)prunedFiles.size() <= optionManager.getOption(PlannerSettings.PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING_THRESHOLD)) {
                this.matchAllMetadata = true;
                this.files = this.filterAndGetMetadata(schemaPathsInExpr, prunedFiles.values(), filterPredicate, optionManager).stream().collect(Collectors.toMap(FileMetadata::getPath, Function.identity()));
            } else {
                this.matchAllMetadata = false;
                this.files = prunedFiles;
                this.overflowLevel = MetadataType.FILE;
            }
        }

        protected static <T extends BaseMetadata> Map<Path, T> pruneForSegments(Map<Path, T> metadataToPrune, Map<Path, SegmentMetadata> filteredSegmentMetadata) {
            HashMap<Path, BaseMetadata> prunedFiles = new HashMap<Path, BaseMetadata>();
            if (metadataToPrune != null) {
                block0: for (Map.Entry<Path, T> entry : metadataToPrune.entrySet()) {
                    for (SegmentMetadata filteredPartition : filteredSegmentMetadata.values()) {
                        if (!filteredPartition.getLocations().contains(entry.getKey())) continue;
                        prunedFiles.put(entry.getKey(), (BaseMetadata)entry.getValue());
                        continue block0;
                    }
                }
            }
            return prunedFiles;
        }

        protected List<PartitionMetadata> pruneForSegments(List<PartitionMetadata> metadataToPrune, Map<Path, SegmentMetadata> filteredSegmentMetadata) {
            ArrayList<PartitionMetadata> prunedPartitions = new ArrayList<PartitionMetadata>();
            if (metadataToPrune != null) {
                block0: for (PartitionMetadata partition : metadataToPrune) {
                    for (SegmentMetadata segment : filteredSegmentMetadata.values()) {
                        if (Collections.disjoint(segment.getLocations(), partition.getLocations())) continue;
                        prunedPartitions.add(partition);
                        continue block0;
                    }
                }
            }
            return prunedPartitions;
        }

        public <T extends Metadata> List<T> filterAndGetMetadata(Set<SchemaPath> schemaPathsInExpr, Iterable<T> metadataList, FilterPredicate<?> filterPredicate, OptionManager optionManager) {
            ArrayList<Metadata> qualifiedMetadata = new ArrayList<Metadata>();
            for (Metadata metadata : metadataList) {
                RowsMatch match;
                TupleMetadata schema = metadata.getSchema();
                if (schema != null && !this.tableSchema.isEquivalent(schema)) {
                    schema = FixedReceiver.Builder.mergeSchemas(schema, this.tableSchema);
                    filterPredicate = AbstractGroupScanWithMetadata.getFilterPredicate(this.filterExpression, this.udfUtilities, this.context, optionManager, true, true, schema);
                }
                Map<SchemaPath, ColumnStatistics<?>> columnsStatistics = metadata.getColumnsStatistics();
                columnsStatistics = this.getImplicitColumnStatistics(optionManager, metadata, columnsStatistics);
                if (this.source.getNonInterestingColumnsMetadata() != null) {
                    columnsStatistics.putAll(this.source.getNonInterestingColumnsMetadata().getColumnsStatistics());
                }
                if ((match = FilterEvaluatorUtils.matches(filterPredicate, columnsStatistics, TableStatisticsKind.ROW_COUNT.getValue(metadata), schema, schemaPathsInExpr, this.udfUtilities)) == RowsMatch.NONE) continue;
                if (this.matchAllMetadata) {
                    this.matchAllMetadata = match == RowsMatch.ALL;
                }
                qualifiedMetadata.add(metadata);
            }
            if (qualifiedMetadata.isEmpty()) {
                this.matchAllMetadata = false;
            }
            return qualifiedMetadata;
        }

        protected <T extends Metadata> Map<SchemaPath, ColumnStatistics<?>> getImplicitColumnStatistics(OptionManager optionManager, T metadata, Map<SchemaPath, ColumnStatistics<?>> columnsStatistics) {
            if (metadata instanceof LocationProvider && optionManager != null) {
                LocationProvider locationProvider = (LocationProvider)((Object)metadata);
                columnsStatistics = ParquetTableMetadataUtils.addImplicitColumnsStatistics(columnsStatistics, this.source.columns, this.source.getPartitionValues(locationProvider), optionManager, locationProvider.getPath(), this.source.supportsFileImplicitColumns());
            }
            return columnsStatistics;
        }

        protected abstract B self();
    }
}

