/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.ops;

import com.carrotsearch.hppc.ObjectIntHashMap;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.planner.sql.conversion.DrillViewExpander;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewExpansionContext {
    private static final Logger logger = LoggerFactory.getLogger(ViewExpansionContext.class);
    private final SchemaConfig.SchemaConfigInfoProvider schemaConfigInfoProvider;
    private final int maxChainedUserHops;
    private final UserBitShared.UserCredentials queryUserCredentials;
    private final ObjectIntHashMap<String> userTokens = new ObjectIntHashMap();
    private final boolean impersonationEnabled;
    private DrillViewExpander viewExpander;

    public ViewExpansionContext(QueryContext queryContext) {
        this(queryContext.getConfig(), queryContext);
    }

    public ViewExpansionContext(DrillConfig config, SchemaConfig.SchemaConfigInfoProvider schemaConfigInfoProvider) {
        this.schemaConfigInfoProvider = schemaConfigInfoProvider;
        this.maxChainedUserHops = config.getInt("drill.exec.impersonation.max_chained_user_hops");
        this.queryUserCredentials = schemaConfigInfoProvider.getQueryUserCredentials();
        this.impersonationEnabled = config.getBoolean("drill.exec.impersonation.enabled");
    }

    public boolean isImpersonationEnabled() {
        return this.impersonationEnabled;
    }

    public ViewExpansionToken reserveViewExpansionToken(String viewOwner) {
        int totalTokens = 1;
        if (!viewOwner.equals(this.queryUserCredentials.getUserName())) {
            if (this.userTokens.containsKey((Object)viewOwner)) {
                totalTokens += this.userTokens.get((Object)viewOwner);
            } else if (this.userTokens.size() == this.maxChainedUserHops) {
                String errMsg = String.format("Cannot issue token for view expansion as issuing the token exceeds the maximum allowed number of user hops (%d) in chained impersonation.", this.maxChainedUserHops);
                logger.error(errMsg);
                throw UserException.permissionError().message(errMsg, new Object[0]).build(logger);
            }
            this.userTokens.put((Object)viewOwner, totalTokens);
            logger.debug("Issued view expansion token for user '{}'", (Object)viewOwner);
        }
        return new ViewExpansionToken(viewOwner);
    }

    private void releaseViewExpansionToken(ViewExpansionToken token) {
        String viewOwner = token.viewOwner;
        if (viewOwner.equals(this.queryUserCredentials.getUserName())) {
            return;
        }
        Preconditions.checkState(this.userTokens.containsKey((Object)token.viewOwner), "Given user doesn't exist in User Token store. Make sure token for this user is obtained first.");
        int userTokenCount = this.userTokens.get((Object)viewOwner);
        if (userTokenCount == 1) {
            this.userTokens.remove((Object)viewOwner);
        } else {
            this.userTokens.put((Object)viewOwner, userTokenCount - 1);
        }
        logger.debug("Released view expansion token issued for user '{}'", (Object)viewOwner);
    }

    public void setViewExpander(DrillViewExpander viewExpander) {
        this.viewExpander = viewExpander;
    }

    public DrillViewExpander getViewExpander() {
        return this.viewExpander;
    }

    public class ViewExpansionToken {
        private final String viewOwner;
        private boolean released;

        ViewExpansionToken(String viewOwner) {
            this.viewOwner = viewOwner;
        }

        public SchemaPlus getSchemaTree() {
            Preconditions.checkState(!this.released, "Trying to use released token.");
            return ViewExpansionContext.this.schemaConfigInfoProvider.getRootSchema(this.viewOwner);
        }

        public void release() {
            if (!this.released) {
                this.released = true;
                ViewExpansionContext.this.releaseViewExpansionToken(this);
            }
        }
    }
}

