/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.ops;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.OpProfileDef;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;

public class FragmentStats {
    private final Map<ImmutablePair<Integer, String>, OperatorStats> operators = new LinkedHashMap<ImmutablePair<Integer, String>, OperatorStats>();
    private final long startTime = System.currentTimeMillis();
    private final CoordinationProtos.DrillbitEndpoint endpoint;
    private final BufferAllocator allocator;

    public FragmentStats(BufferAllocator allocator, CoordinationProtos.DrillbitEndpoint endpoint) {
        this.endpoint = endpoint;
        this.allocator = allocator;
    }

    public void addMetricsToStatus(UserBitShared.MinorFragmentProfile.Builder prfB) {
        prfB.setStartTime(this.startTime);
        prfB.setMaxMemoryUsed(this.allocator.getPeakMemoryAllocation());
        prfB.setEndTime(System.currentTimeMillis());
        prfB.setEndpoint(this.endpoint);
        for (Map.Entry<ImmutablePair<Integer, String>, OperatorStats> o : this.operators.entrySet()) {
            prfB.addOperatorProfile(o.getValue().getProfile());
        }
    }

    public OperatorStats newOperatorStats(OpProfileDef profileDef, BufferAllocator allocator) {
        OperatorStats stats = new OperatorStats(profileDef, allocator);
        if (profileDef.operatorType != null) {
            this.addOperatorStats(stats);
        }
        return stats;
    }

    public void addOperatorStats(OperatorStats stats) {
        this.operators.put((ImmutablePair<Integer, String>)new ImmutablePair((Object)stats.operatorId, (Object)stats.operatorType), stats);
    }
}

