/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.ops;

import io.netty.buffer.DrillBuf;
import java.util.List;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.ops.BufferManager;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.impl.common.CodeGenMemberInjector;
import org.apache.drill.exec.proto.UserBitShared;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFragmentContext
implements FragmentContext {
    private static final Logger logger = LoggerFactory.getLogger(BaseFragmentContext.class);
    private final FunctionImplementationRegistry funcRegistry;

    public BaseFragmentContext(FunctionImplementationRegistry funcRegistry) {
        this.funcRegistry = funcRegistry;
    }

    @Override
    public FunctionImplementationRegistry getFunctionRegistry() {
        return this.funcRegistry;
    }

    @Override
    public <T> T getImplementationClass(ClassGenerator<T> cg) {
        return this.getImplementationClass(cg.getCodeGenerator());
    }

    @Override
    public <T> T getImplementationClass(CodeGenerator<T> cg) {
        Object instance;
        try {
            instance = this.getCompiler().createInstance(cg);
        }
        catch (ClassTransformationException e) {
            throw UserException.internalError(e).message("Code generation error - likely code error.", new Object[0]).build(logger);
        }
        CodeGenMemberInjector.injectMembers(cg.getRoot(), instance, this);
        return instance;
    }

    @Override
    public <T> List<T> getImplementationClass(ClassGenerator<T> cg, int instanceCount) {
        return this.getImplementationClass(cg.getCodeGenerator(), instanceCount);
    }

    @Override
    public <T> List<T> getImplementationClass(CodeGenerator<T> cg, int instanceCount) {
        List<Object> instances;
        try {
            instances = this.getCompiler().createInstances(cg, instanceCount);
        }
        catch (ClassTransformationException e) {
            throw UserException.internalError(e).message("Code generation error - likely code error.", new Object[0]).build(logger);
        }
        instances.forEach(instance -> CodeGenMemberInjector.injectMembers(cg.getRoot(), instance, this));
        return instances;
    }

    protected abstract BufferManager getBufferManager();

    @Override
    public DrillBuf replace(DrillBuf old, int newSize) {
        return this.getBufferManager().replace(old, newSize);
    }

    @Override
    public DrillBuf getManagedBuffer() {
        return this.getBufferManager().getManagedBuffer();
    }

    @Override
    public DrillBuf getManagedBuffer(int size) {
        return this.getBufferManager().getManagedBuffer(size);
    }

    @Override
    public String getQueryUserName() {
        return null;
    }

    @Override
    public UserBitShared.QueryId getQueryId() {
        return null;
    }

    @Override
    public String getQueryIdString() {
        return null;
    }

    @Override
    public QueryContext.SqlStatementType getSQLStatementType() {
        return null;
    }

    @Override
    public BufferManager getManagedBufferManager() {
        return this.getBufferManager();
    }
}

