/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.ops;

import org.apache.drill.exec.ops.SendingAccountor;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.record.FragmentWritableBatch;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.rpc.data.DataTunnel;
import org.apache.drill.exec.testing.ControlsInjector;
import org.apache.drill.exec.testing.ExecutionControls;
import org.apache.drill.exec.work.filter.RuntimeFilterWritable;
import org.slf4j.Logger;

public class AccountingDataTunnel {
    private final DataTunnel tunnel;
    private final SendingAccountor sendingAccountor;
    private final RpcOutcomeListener<BitData.AckWithCredit> statusHandler;

    public AccountingDataTunnel(DataTunnel tunnel, SendingAccountor sendingAccountor, RpcOutcomeListener<BitData.AckWithCredit> statusHandler) {
        this.tunnel = tunnel;
        this.sendingAccountor = sendingAccountor;
        this.statusHandler = statusHandler;
    }

    public void sendRecordBatch(FragmentWritableBatch batch) {
        this.sendingAccountor.increment();
        this.tunnel.sendRecordBatch(this.statusHandler, batch);
    }

    public void sendRuntimeFilter(RuntimeFilterWritable batch) {
        this.sendingAccountor.increment();
        this.tunnel.sendRuntimeFilter(this.statusHandler, batch);
    }

    public void setTestInjectionControls(ControlsInjector testInjector, ExecutionControls testControls, Logger testLogger) {
        this.tunnel.setTestInjectionControls(testInjector, testControls, testLogger);
    }
}

