/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.oauth;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.exception.StoreException;
import org.apache.drill.exec.oauth.PersistentTokenTable;
import org.apache.drill.exec.oauth.TokenRegistry;
import org.apache.drill.exec.oauth.Tokens;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.sys.PersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;

public class PersistentTokenRegistry
implements TokenRegistry {
    private final PersistentStore<PersistentTokenTable> store;

    public PersistentTokenRegistry(DrillbitContext context, String registryPath) {
        try {
            ObjectMapper mapper = context.getLpPersistence().getMapper().copy();
            InjectableValues.Std injectables = new InjectableValues.Std().addValue(StoreProvider.class, (Object)new StoreProvider(this::getStore));
            mapper.setInjectableValues((InjectableValues)injectables);
            this.store = context.getStoreProvider().getOrCreateStore(PersistentStoreConfig.newJacksonBuilder(mapper, PersistentTokenTable.class).name(registryPath).build());
        }
        catch (StoreException e) {
            throw new DrillRuntimeException("Failure while reading and loading token table.");
        }
    }

    public PersistentStore<PersistentTokenTable> getStore() {
        return this.store;
    }

    @Override
    public PersistentTokenTable getTokenTable(String name) {
        if (!this.store.contains(name = name.toLowerCase())) {
            this.createTokenTable(name);
        }
        return this.store.get(name);
    }

    @Override
    public Iterator<Map.Entry<String, Tokens>> getAllTokens() {
        return this.store.getAll();
    }

    @Override
    public void createTokenTable(String pluginName) {
        if (!this.store.contains(pluginName = pluginName.toLowerCase())) {
            PersistentTokenTable tokenTable = new PersistentTokenTable(new HashMap<String, String>(), pluginName, new StoreProvider(this::getStore));
            this.store.put(pluginName, tokenTable);
        }
    }

    @Override
    public void deleteTokenTable(String pluginName) {
        if (this.store.contains(pluginName = pluginName.toLowerCase())) {
            this.store.delete(pluginName);
        }
    }

    @Override
    public void close() throws Exception {
        this.store.close();
    }

    public static class StoreProvider {
        private final Supplier<PersistentStore<PersistentTokenTable>> supplier;

        public StoreProvider(Supplier<PersistentStore<PersistentTokenTable>> supplier) {
            this.supplier = supplier;
        }

        public PersistentStore<PersistentTokenTable> getStore() {
            return this.supplier.get();
        }
    }
}

