/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.metastore.analyze;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.drill.metastore.metadata.MetadataInfo;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.TableInfo;

@JsonDeserialize(builder=MetadataHandlerContextBuilder.class)
public class MetadataHandlerContext {
    private final TableInfo tableInfo;
    private final List<MetadataInfo> metadataToHandle;
    private final MetadataType metadataType;
    private final int depthLevel;
    private final List<String> segmentColumns;

    private MetadataHandlerContext(MetadataHandlerContextBuilder builder) {
        this.tableInfo = builder.tableInfo;
        this.metadataToHandle = builder.metadataToHandle;
        this.metadataType = builder.metadataType;
        this.depthLevel = builder.depthLevel;
        this.segmentColumns = builder.segmentColumns;
    }

    @JsonProperty
    public TableInfo tableInfo() {
        return this.tableInfo;
    }

    @JsonProperty
    public List<MetadataInfo> metadataToHandle() {
        return this.metadataToHandle;
    }

    @JsonProperty
    public MetadataType metadataType() {
        return this.metadataType;
    }

    @JsonProperty
    public int depthLevel() {
        return this.depthLevel;
    }

    @JsonProperty
    public List<String> segmentColumns() {
        return this.segmentColumns;
    }

    public String toString() {
        return new StringJoiner(",\n", MetadataHandlerContext.class.getSimpleName() + "[", "]").add("tableInfo=" + this.tableInfo).add("metadataToHandle=" + this.metadataToHandle).add("metadataType=" + (Object)((Object)this.metadataType)).add("depthLevel=" + this.depthLevel).add("segmentColumns=" + this.segmentColumns).toString();
    }

    public static MetadataHandlerContextBuilder builder() {
        return new MetadataHandlerContextBuilder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class MetadataHandlerContextBuilder {
        private TableInfo tableInfo;
        private List<MetadataInfo> metadataToHandle;
        private MetadataType metadataType;
        private Integer depthLevel;
        private List<String> segmentColumns;

        public MetadataHandlerContextBuilder tableInfo(TableInfo tableInfo) {
            this.tableInfo = tableInfo;
            return this;
        }

        public MetadataHandlerContextBuilder metadataToHandle(List<MetadataInfo> metadataToHandle) {
            this.metadataToHandle = metadataToHandle;
            return this;
        }

        public MetadataHandlerContextBuilder metadataType(MetadataType metadataType) {
            this.metadataType = metadataType;
            return this;
        }

        public MetadataHandlerContextBuilder depthLevel(int depthLevel) {
            this.depthLevel = depthLevel;
            return this;
        }

        public MetadataHandlerContextBuilder segmentColumns(List<String> segmentColumns) {
            this.segmentColumns = segmentColumns;
            return this;
        }

        public MetadataHandlerContext build() {
            Objects.requireNonNull(this.tableInfo, "tableInfo was not set");
            Objects.requireNonNull(this.metadataToHandle, "metadataToHandle was not set");
            Objects.requireNonNull(this.metadataType, "metadataType was not set");
            Objects.requireNonNull(this.depthLevel, "depthLevel was not set");
            Objects.requireNonNull(this.segmentColumns, "segmentColumns were not set");
            return new MetadataHandlerContext(this);
        }
    }
}

