/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.metastore.analyze;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.metastore.components.tables.MetastoreTableInfo;
import org.apache.drill.metastore.metadata.MetadataInfo;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.hadoop.fs.Path;

@JsonDeserialize(builder=MetadataControllerContextBuilder.class)
public class MetadataControllerContext {
    private final TableInfo tableInfo;
    private final MetastoreTableInfo metastoreTableInfo;
    private final Path location;
    private final List<SchemaPath> interestingColumns;
    private final List<String> segmentColumns;
    private final List<MetadataInfo> metadataToHandle;
    private final List<MetadataInfo> metadataToRemove;
    private final MetadataType analyzeMetadataLevel;
    private final boolean multiValueSegments;

    private MetadataControllerContext(MetadataControllerContextBuilder builder) {
        this.tableInfo = builder.tableInfo;
        this.metastoreTableInfo = builder.metastoreTableInfo;
        this.location = builder.location;
        this.interestingColumns = builder.interestingColumns;
        this.segmentColumns = builder.segmentColumns;
        this.metadataToHandle = builder.metadataToHandle;
        this.metadataToRemove = builder.metadataToRemove;
        this.analyzeMetadataLevel = builder.analyzeMetadataLevel;
        this.multiValueSegments = builder.multiValueSegments;
    }

    @JsonProperty
    public TableInfo tableInfo() {
        return this.tableInfo;
    }

    @JsonProperty
    public MetastoreTableInfo metastoreTableInfo() {
        return this.metastoreTableInfo;
    }

    @JsonProperty
    public Path location() {
        return this.location;
    }

    @JsonProperty
    public List<SchemaPath> interestingColumns() {
        return this.interestingColumns;
    }

    @JsonProperty
    public List<String> segmentColumns() {
        return this.segmentColumns;
    }

    @JsonProperty
    public List<MetadataInfo> metadataToHandle() {
        return this.metadataToHandle;
    }

    @JsonProperty
    public List<MetadataInfo> metadataToRemove() {
        return this.metadataToRemove;
    }

    @JsonProperty
    public MetadataType analyzeMetadataLevel() {
        return this.analyzeMetadataLevel;
    }

    @JsonProperty
    public boolean multiValueSegments() {
        return this.multiValueSegments;
    }

    public String toString() {
        return new StringJoiner(",\n", MetadataControllerContext.class.getSimpleName() + "[", "]").add("tableInfo=" + this.tableInfo).add("location=" + this.location).add("interestingColumns=" + this.interestingColumns).add("segmentColumns=" + this.segmentColumns).add("metadataToHandle=" + this.metadataToHandle).add("metadataToRemove=" + this.metadataToRemove).add("analyzeMetadataLevel=" + (Object)((Object)this.analyzeMetadataLevel)).toString();
    }

    public static MetadataControllerContextBuilder builder() {
        return new MetadataControllerContextBuilder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class MetadataControllerContextBuilder {
        private TableInfo tableInfo;
        private MetastoreTableInfo metastoreTableInfo;
        private Path location;
        private List<SchemaPath> interestingColumns;
        private List<String> segmentColumns;
        private List<MetadataInfo> metadataToHandle;
        private List<MetadataInfo> metadataToRemove;
        private MetadataType analyzeMetadataLevel;
        private boolean multiValueSegments;

        public MetadataControllerContextBuilder tableInfo(TableInfo tableInfo) {
            this.tableInfo = tableInfo;
            return this;
        }

        public MetadataControllerContextBuilder metastoreTableInfo(MetastoreTableInfo metastoreTableInfo) {
            this.metastoreTableInfo = metastoreTableInfo;
            return this;
        }

        public MetadataControllerContextBuilder location(Path location) {
            this.location = location;
            return this;
        }

        public MetadataControllerContextBuilder interestingColumns(List<SchemaPath> interestingColumns) {
            this.interestingColumns = interestingColumns;
            return this;
        }

        public MetadataControllerContextBuilder segmentColumns(List<String> segmentColumns) {
            this.segmentColumns = segmentColumns;
            return this;
        }

        public MetadataControllerContextBuilder metadataToHandle(List<MetadataInfo> metadataToHandle) {
            this.metadataToHandle = metadataToHandle;
            return this;
        }

        public MetadataControllerContextBuilder metadataToRemove(List<MetadataInfo> metadataToRemove) {
            this.metadataToRemove = metadataToRemove;
            return this;
        }

        public MetadataControllerContextBuilder analyzeMetadataLevel(MetadataType metadataType) {
            this.analyzeMetadataLevel = metadataType;
            return this;
        }

        public MetadataControllerContextBuilder multiValueSegments(boolean multiValueSegments) {
            this.multiValueSegments = multiValueSegments;
            return this;
        }

        public MetadataControllerContext build() {
            Objects.requireNonNull(this.tableInfo, "tableInfo was not set");
            Objects.requireNonNull(this.location, "location was not set");
            Objects.requireNonNull(this.segmentColumns, "segmentColumns were not set");
            Objects.requireNonNull(this.metadataToRemove, "metadataToRemove was not set");
            return new MetadataControllerContext(this);
        }
    }
}

