/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.metastore;

import java.util.StringJoiner;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.server.options.OptionManager;

public class ColumnNamesOptions {
    private final String fullyQualifiedName;
    private final String partitionColumnNameLabel;
    private final String rowGroupIndex;
    private final String rowGroupStart;
    private final String rowGroupLength;
    private final String lastModifiedTime;
    private final String projectMetadataColumn;

    public ColumnNamesOptions(OptionManager optionManager) {
        this.fullyQualifiedName = optionManager.getOption(ExecConstants.IMPLICIT_FQN_COLUMN_LABEL_VALIDATOR);
        this.partitionColumnNameLabel = optionManager.getOption(ExecConstants.FILESYSTEM_PARTITION_COLUMN_LABEL_VALIDATOR);
        this.rowGroupIndex = optionManager.getOption(ExecConstants.IMPLICIT_ROW_GROUP_INDEX_COLUMN_LABEL_VALIDATOR);
        this.rowGroupStart = optionManager.getOption(ExecConstants.IMPLICIT_ROW_GROUP_START_COLUMN_LABEL_VALIDATOR);
        this.rowGroupLength = optionManager.getOption(ExecConstants.IMPLICIT_ROW_GROUP_LENGTH_COLUMN_LABEL_VALIDATOR);
        this.lastModifiedTime = optionManager.getOption(ExecConstants.IMPLICIT_LAST_MODIFIED_TIME_COLUMN_LABEL_VALIDATOR);
        this.projectMetadataColumn = optionManager.getOption(ExecConstants.IMPLICIT_PROJECT_METADATA_COLUMN_LABEL_VALIDATOR);
    }

    public String partitionColumnNameLabel() {
        return this.partitionColumnNameLabel;
    }

    public String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public String rowGroupIndex() {
        return this.rowGroupIndex;
    }

    public String rowGroupStart() {
        return this.rowGroupStart;
    }

    public String rowGroupLength() {
        return this.rowGroupLength;
    }

    public String lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String projectMetadataColumn() {
        return this.projectMetadataColumn;
    }

    public String toString() {
        return new StringJoiner(", ", ColumnNamesOptions.class.getSimpleName() + "[", "]").add("fullyQualifiedName='" + this.fullyQualifiedName + "'").add("partitionColumnNameLabel='" + this.partitionColumnNameLabel + "'").add("rowGroupIndex='" + this.rowGroupIndex + "'").add("rowGroupStart='" + this.rowGroupStart + "'").add("rowGroupLength='" + this.rowGroupLength + "'").add("lastModifiedTime='" + this.lastModifiedTime + "'").add("projectMetadataColumn='" + this.projectMetadataColumn + "'").toString();
    }
}

