/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.registry;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.coord.store.TransientStore;
import org.apache.drill.exec.coord.store.TransientStoreConfig;
import org.apache.drill.exec.coord.store.TransientStoreListener;
import org.apache.drill.exec.exception.StoreException;
import org.apache.drill.exec.exception.VersionMismatchException;
import org.apache.drill.exec.proto.SchemaUserBitShared;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;
import org.apache.drill.exec.store.sys.PersistentStoreProvider;
import org.apache.drill.exec.store.sys.VersionedPersistentStore;
import org.apache.drill.exec.store.sys.store.DataChangeVersion;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteFunctionRegistry
implements AutoCloseable {
    private static final String REGISTRY_PATH = "registry";
    private static final Logger logger = LoggerFactory.getLogger(RemoteFunctionRegistry.class);
    private static final ObjectMapper mapper = JacksonUtils.createObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final TransientStoreListener unregistrationListener;
    private int retryAttempts;
    private FileSystem fs;
    private Path registryArea;
    private Path stagingArea;
    private Path tmpArea;
    private VersionedPersistentStore<UserBitShared.Registry> registry;
    private TransientStore<String> unregistration;
    private TransientStore<String> jars;

    public RemoteFunctionRegistry(TransientStoreListener unregistrationListener) {
        this.unregistrationListener = unregistrationListener;
    }

    public void init(DrillConfig config, PersistentStoreProvider storeProvider, ClusterCoordinator coordinator) {
        this.prepareStores(storeProvider, coordinator);
        this.prepareAreas(config);
        this.retryAttempts = config.getInt("drill.exec.udf.retry-attempts");
    }

    public int getRegistryVersion() {
        DataChangeVersion version = new DataChangeVersion();
        boolean contains = false;
        try {
            contains = this.registry.contains(REGISTRY_PATH, version);
        }
        catch (Exception e) {
            logger.error("Problem during trying to access remote function registry [{}]", (Object)REGISTRY_PATH, (Object)e);
        }
        if (contains) {
            return version.getVersion();
        }
        logger.error("Remote function registry [{}] is unreachable", (Object)REGISTRY_PATH);
        return -1;
    }

    public boolean hasRegistry() {
        return this.registry != null;
    }

    public UserBitShared.Registry getRegistry(DataChangeVersion version) {
        return this.registry.get(REGISTRY_PATH, version);
    }

    public void updateRegistry(UserBitShared.Registry registryContent, DataChangeVersion version) throws VersionMismatchException {
        this.registry.put(REGISTRY_PATH, registryContent, version);
    }

    public void submitForUnregistration(String jar) {
        this.unregistration.putIfAbsent(jar, jar);
    }

    public void finishUnregistration(String jar) {
        this.unregistration.remove(jar);
    }

    public String addToJars(String jar, Action action) {
        return this.jars.putIfAbsent(jar, action.toString());
    }

    public void removeFromJars(String jar) {
        this.jars.remove(jar);
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public Path getRegistryArea() {
        return this.registryArea;
    }

    public Path getStagingArea() {
        return this.stagingArea;
    }

    public Path getTmpArea() {
        return this.tmpArea;
    }

    private void prepareStores(PersistentStoreProvider storeProvider, ClusterCoordinator coordinator) {
        try {
            PersistentStoreConfig<UserBitShared.Registry> registrationConfig = PersistentStoreConfig.newProtoBuilder(SchemaUserBitShared.Registry.WRITE, SchemaUserBitShared.Registry.MERGE).name("udf").persist().build();
            this.registry = storeProvider.getOrCreateVersionedStore(registrationConfig);
            logger.trace("Remote function registry type: {}.", this.registry.getClass());
            this.registry.putIfAbsent(REGISTRY_PATH, UserBitShared.Registry.getDefaultInstance());
        }
        catch (StoreException e) {
            throw new DrillRuntimeException("Failure while loading remote registry.", e);
        }
        TransientStoreConfig<String> unregistrationConfig = TransientStoreConfig.newJacksonBuilder(mapper, String.class).name("udf/unregister").build();
        this.unregistration = coordinator.getOrCreateTransientStore(unregistrationConfig);
        this.unregistration.addListener(this.unregistrationListener);
        TransientStoreConfig<String> jarsConfig = TransientStoreConfig.newJacksonBuilder(mapper, String.class).name("udf/jars").build();
        this.jars = coordinator.getOrCreateTransientStore(jarsConfig);
    }

    private void prepareAreas(DrillConfig config) {
        logger.info("Preparing three remote udf areas: staging, registry and tmp.");
        Configuration conf = new Configuration();
        if (config.hasPath("drill.exec.udf.directory.fs")) {
            conf.set("fs.defaultFS", config.getString("drill.exec.udf.directory.fs"));
        }
        try {
            this.fs = FileSystem.get((Configuration)conf);
        }
        catch (IOException e) {
            throw DrillRuntimeException.create(e, "Error during file system %s setup", conf.get("fs.defaultFS"));
        }
        String root = this.fs.getHomeDirectory().toUri().getPath();
        if (config.hasPath("drill.exec.udf.directory.root")) {
            root = config.getString("drill.exec.udf.directory.root");
        }
        this.registryArea = this.createArea(this.fs, root, config.getString("drill.exec.udf.directory.registry"));
        this.stagingArea = this.createArea(this.fs, root, config.getString("drill.exec.udf.directory.staging"));
        this.tmpArea = this.createArea(this.fs, root, config.getString("drill.exec.udf.directory.tmp"));
    }

    private Path createArea(FileSystem fs, String root, String directory) {
        Path path = new Path(new File(root, directory).toURI().getPath());
        String fullPath = path.toUri().getPath();
        try {
            fs.mkdirs(path);
            Preconditions.checkState(fs.exists(path), "Area [%s] must exist", (Object)fullPath);
            FileStatus fileStatus = fs.getFileStatus(path);
            Preconditions.checkState(fileStatus.isDirectory(), "Area [%s] must be a directory", (Object)fullPath);
            FsPermission permission = fileStatus.getPermission();
            Preconditions.checkState(ImpersonationUtil.getProcessUserName().equals(fileStatus.getOwner()) && permission.getUserAction().implies(FsAction.WRITE) || Sets.newHashSet(ImpersonationUtil.getProcessUserGroupNames()).contains(fileStatus.getGroup()) && permission.getGroupAction().implies(FsAction.WRITE) || permission.getOtherAction().implies(FsAction.WRITE), "Area [%s] must be writable and executable for application user", (Object)fullPath);
        }
        catch (Exception e) {
            if (e instanceof DrillRuntimeException) {
                throw (DrillRuntimeException)e;
            }
            throw DrillRuntimeException.create(e, "Error during udf area creation [%s] on file system [%s]", fullPath, fs.getUri());
        }
        logger.info("Created remote udf area [{}] on file system [{}]", (Object)fullPath, (Object)fs.getUri());
        return path;
    }

    @Override
    public void close() {
        try {
            AutoCloseables.close(new AutoCloseable[]{this.fs, this.registry, this.unregistration, this.jars});
        }
        catch (Exception e) {
            logger.warn("Failure on close()", (Throwable)e);
        }
    }

    public static enum Action {
        REGISTRATION,
        UNREGISTRATION;

    }
}

