/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.output;

import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.fn.FunctionAttributes;
import org.apache.drill.exec.expr.fn.FunctionUtils;
import org.apache.drill.exec.expr.fn.output.ReturnTypeInference;
import org.apache.drill.shaded.guava.com.google.common.primitives.Ints;

public class StringCastReturnTypeInference
implements ReturnTypeInference {
    public static final StringCastReturnTypeInference INSTANCE = new StringCastReturnTypeInference();

    @Override
    public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
        TypeProtos.MajorType.Builder builder = TypeProtos.MajorType.newBuilder().setMinorType(attributes.getReturnValue().getType().getMinorType()).setMode(FunctionUtils.getReturnTypeDataMode(logicalExpressions, attributes));
        LogicalExpression logicalExpression = logicalExpressions.get(1);
        if (logicalExpressions.get(1) instanceof ValueExpressions.LongExpression) {
            long precision = ((ValueExpressions.LongExpression)logicalExpression).getLong();
            builder.setPrecision(Ints.checkedCast(precision));
        }
        return builder.build();
    }
}

