/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castDECIMAL9", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastVarDecimalDecimal9
implements DrillSimpleFunc {
    @Param
    VarDecimalHolder in;
    @Param
    IntHolder precision;
    @Param
    IntHolder scale;
    @Output
    Decimal9Holder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        this.out.scale = this.scale.value;
        this.out.precision = this.precision.value;
        BigDecimal bd = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale).setScale(this.scale.value, RoundingMode.HALF_UP).round(new MathContext(this.precision.value, RoundingMode.HALF_UP));
        this.out.value = DecimalUtility.getDecimal9FromBigDecimal(bd, this.out.scale);
    }
}

