/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.StringFunctionUtil;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

@FunctionTemplate(name="castVARCHAR", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.STRING_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastVarBinaryVarChar
implements DrillSimpleFunc {
    @Param
    VarBinaryHolder in;
    @Param
    BigIntHolder length;
    @Output
    VarCharHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        int charCount = StringFunctionUtil.getUTF8CharLength(this.in.buffer, this.in.start, this.in.end);
        this.out.buffer = this.in.buffer;
        this.out.start = this.in.start;
        this.out.end = (long)charCount <= this.length.value || this.length.value == 0L ? this.in.end : StringFunctionUtil.getUTF8CharPosition(this.in.buffer, this.in.start, this.in.end, (int)this.length.value);
    }
}

