/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CastHighFunctions {
    static final Logger logger = LoggerFactory.getLogger(CastHighFunctions.class);

    @FunctionTemplate(name="casthigh", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_AGGREGATE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastHighVarDecimal
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder in;
        @Output
        VarDecimalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.buffer = this.in.buffer;
            this.out.start = this.in.start;
            this.out.scale = this.in.scale;
            this.out.precision = this.in.precision;
            this.out.end = this.in.end;
        }
    }

    @FunctionTemplate(name="casthigh", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_AGGREGATE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastHighDecimal38Sparse
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder in;
        @Output
        Decimal38SparseHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out = this.in;
        }
    }

    @FunctionTemplate(name="casthigh", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_AGGREGATE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastHighDecimal28Sparse
    implements DrillSimpleFunc {
        @Param
        Decimal28SparseHolder in;
        @Output
        Decimal28SparseHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out = this.in;
        }
    }

    @FunctionTemplate(name="casthigh", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_AGGREGATE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastHighDecimal18
    implements DrillSimpleFunc {
        @Param
        Decimal18Holder in;
        @Output
        Decimal18Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out = this.in;
        }
    }

    @FunctionTemplate(name="casthigh", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_AGGREGATE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastHighDecimal9
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder in;
        @Output
        Decimal9Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out = this.in;
        }
    }

    @FunctionTemplate(name="casthigh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastHighFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="casthigh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastHighFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="casthigh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastHighBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="casthigh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastHighInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }
}

