/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.IntHolder;

@FunctionTemplate(name="castINT", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastFloat4Int
implements DrillSimpleFunc {
    @Param
    Float4Holder in;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        float fractional = this.in.value % 1.0f;
        int digit = (int)(fractional * 10.0f);
        int carry = 0;
        if (Math.abs(digit) > 4) {
            carry = (int)Math.signum(digit);
        }
        this.out.value = (int)(this.in.value + (float)carry);
    }
}

