/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import com.google.common.base.Charsets;
import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castEmptyStringNullableVarCharToNULLABLEVARDECIMAL", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.INTERNAL)
public class CastEmptyStringNullableVarCharToNullableVarDecimal
implements DrillSimpleFunc {
    @Param
    NullableVarCharHolder in;
    @Inject
    DrillBuf buffer;
    @Param
    IntHolder precision;
    @Param
    IntHolder scale;
    @Output
    NullableVarDecimalHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        if (this.in.isSet == 0 || this.in.end == this.in.start) {
            this.out.isSet = 0;
            return;
        }
        this.out.isSet = 1;
        this.out.start = 0;
        this.out.scale = this.scale.value;
        this.out.precision = this.precision.value;
        byte[] buf = new byte[this.in.end - this.in.start];
        this.in.buffer.getBytes(this.in.start, buf, 0, this.in.end - this.in.start);
        String s = new String(buf, Charsets.UTF_8);
        BigDecimal bd = new BigDecimal(s);
        DecimalUtility.checkValueOverflow(bd, this.precision.value, this.scale.value);
        bd = bd.setScale(this.scale.value, RoundingMode.HALF_UP);
        byte[] bytes = bd.unscaledValue().toByteArray();
        int len = bytes.length;
        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
        this.out.buffer.setBytes(this.out.start, bytes);
        this.out.end = this.out.start + len;
    }
}

