/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castVARDECIMAL", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastBigIntVarDecimal
implements DrillSimpleFunc {
    @Param
    BigIntHolder in;
    @Inject
    DrillBuf buffer;
    @Param
    IntHolder precision;
    @Param
    IntHolder scale;
    @Output
    VarDecimalHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        this.out.scale = this.scale.value;
        this.out.precision = this.precision.value;
        this.out.start = 0;
        BigDecimal bd = new BigDecimal(this.in.value);
        DecimalUtility.checkValueOverflow(bd, this.precision.value, this.scale.value);
        bd = bd.setScale(this.out.scale, 1);
        byte[] bytes = bd.unscaledValue().toByteArray();
        int len = bytes.length;
        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
        this.out.buffer.setBytes(this.out.start, bytes);
        this.out.end = this.out.start + len;
    }
}

