/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;

public class SumFunctions {

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat8Sum
    implements DrillAggFunc {
        @Param
        NullableFloat8Holder in;
        @Workspace
        Float8Holder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.value = new Float8Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 0.0;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value += this.in.value;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 0.0;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat4Sum
    implements DrillAggFunc {
        @Param
        NullableFloat4Holder in;
        @Workspace
        Float8Holder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.value = new Float8Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 0.0;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value += (double)this.in.value;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 0.0;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float8Sum
    implements DrillAggFunc {
        @Param
        Float8Holder in;
        @Workspace
        Float8Holder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.value = new Float8Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 0.0;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value += this.in.value;
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 0.0;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float4Sum
    implements DrillAggFunc {
        @Param
        Float4Holder in;
        @Workspace
        Float8Holder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.value = new Float8Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 0.0;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value += (double)this.in.value;
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 0.0;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBigIntSum
    implements DrillAggFunc {
        @Param
        NullableBigIntHolder in;
        @Workspace
        BigIntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBigIntHolder out;

        @Override
        public void setup() {
            this.value = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 0L;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value += this.in.value;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 0L;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntSum
    implements DrillAggFunc {
        @Param
        NullableIntHolder in;
        @Workspace
        BigIntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBigIntHolder out;

        @Override
        public void setup() {
            this.value = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 0L;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value += (long)this.in.value;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 0L;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BigIntSum
    implements DrillAggFunc {
        @Param
        BigIntHolder in;
        @Workspace
        BigIntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBigIntHolder out;

        @Override
        public void setup() {
            this.value = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 0L;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value += this.in.value;
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 0L;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntSum
    implements DrillAggFunc {
        @Param
        IntHolder in;
        @Workspace
        BigIntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBigIntHolder out;

        @Override
        public void setup() {
            this.value = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 0L;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value += (long)this.in.value;
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 0L;
        }
    }
}

