/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;

public class MinFunctions {

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat8Min
    implements DrillAggFunc {
        @Param
        NullableFloat8Holder in;
        @Workspace
        Float8Holder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.value = new Float8Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Double.NaN;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                if (!Double.isNaN(this.in.value)) {
                    this.value.value = Double.isNaN(this.value.value) ? this.in.value : Math.min(this.value.value, this.in.value);
                }
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Double.NaN;
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat4Min
    implements DrillAggFunc {
        @Param
        NullableFloat4Holder in;
        @Workspace
        Float4Holder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat4Holder out;

        @Override
        public void setup() {
            this.value = new Float4Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Float.NaN;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                if (!Float.isNaN(this.in.value)) {
                    this.value.value = Float.isNaN(this.value.value) ? this.in.value : Math.min(this.value.value, this.in.value);
                }
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Float.NaN;
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float8Min
    implements DrillAggFunc {
        @Param
        Float8Holder in;
        @Workspace
        Float8Holder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.value = new Float8Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Double.NaN;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            if (!Double.isNaN(this.in.value)) {
                this.value.value = Double.isNaN(this.value.value) ? this.in.value : Math.min(this.value.value, this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Double.NaN;
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float4Min
    implements DrillAggFunc {
        @Param
        Float4Holder in;
        @Workspace
        Float4Holder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat4Holder out;

        @Override
        public void setup() {
            this.value = new Float4Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Float.NaN;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            if (!Float.isNaN(this.in.value)) {
                this.value.value = Float.isNaN(this.value.value) ? this.in.value : Math.min(this.value.value, this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Float.NaN;
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBigIntMin
    implements DrillAggFunc {
        @Param
        NullableBigIntHolder in;
        @Workspace
        BigIntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBigIntHolder out;

        @Override
        public void setup() {
            this.value = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Long.MAX_VALUE;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value = Math.min(this.value.value, this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Long.MAX_VALUE;
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntMin
    implements DrillAggFunc {
        @Param
        NullableIntHolder in;
        @Workspace
        IntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntHolder out;

        @Override
        public void setup() {
            this.value = new IntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MAX_VALUE;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value = Math.min(this.value.value, this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MAX_VALUE;
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBitMin
    implements DrillAggFunc {
        @Param
        NullableBitHolder in;
        @Workspace
        BitHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBitHolder out;

        @Override
        public void setup() {
            this.value = new BitHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 1;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value = Math.min(this.value.value, this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 1;
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BigIntMin
    implements DrillAggFunc {
        @Param
        BigIntHolder in;
        @Workspace
        BigIntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBigIntHolder out;

        @Override
        public void setup() {
            this.value = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Long.MAX_VALUE;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value = Math.min(this.value.value, this.in.value);
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Long.MAX_VALUE;
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntMin
    implements DrillAggFunc {
        @Param
        IntHolder in;
        @Workspace
        IntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntHolder out;

        @Override
        public void setup() {
            this.value = new IntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MAX_VALUE;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value = Math.min(this.value.value, this.in.value);
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MAX_VALUE;
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BitMin
    implements DrillAggFunc {
        @Param
        BitHolder in;
        @Workspace
        BitHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBitHolder out;

        @Override
        public void setup() {
            this.value = new BitHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 1;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value = Math.min(this.value.value, this.in.value);
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 1;
        }
    }
}

