/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;

public class MaxFunctions {

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat8Max
    implements DrillAggFunc {
        @Param
        NullableFloat8Holder in;
        @Workspace
        Float8Holder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.value = new Float8Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = -1.7976931348623157E308;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value = Math.max(this.value.value, this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = -1.7976931348623157E308;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat4Max
    implements DrillAggFunc {
        @Param
        NullableFloat4Holder in;
        @Workspace
        Float4Holder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat4Holder out;

        @Override
        public void setup() {
            this.value = new Float4Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = -3.4028235E38f;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value = Math.max(this.value.value, this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = -3.4028235E38f;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float8Max
    implements DrillAggFunc {
        @Param
        Float8Holder in;
        @Workspace
        Float8Holder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.value = new Float8Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = -1.7976931348623157E308;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value = Math.max(this.value.value, this.in.value);
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = -1.7976931348623157E308;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float4Max
    implements DrillAggFunc {
        @Param
        Float4Holder in;
        @Workspace
        Float4Holder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat4Holder out;

        @Override
        public void setup() {
            this.value = new Float4Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = -3.4028235E38f;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value = Math.max(this.value.value, this.in.value);
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = -3.4028235E38f;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBigIntMax
    implements DrillAggFunc {
        @Param
        NullableBigIntHolder in;
        @Workspace
        BigIntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBigIntHolder out;

        @Override
        public void setup() {
            this.value = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value = Math.max(this.value.value, this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntMax
    implements DrillAggFunc {
        @Param
        NullableIntHolder in;
        @Workspace
        IntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntHolder out;

        @Override
        public void setup() {
            this.value = new IntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MIN_VALUE;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value = Math.max(this.value.value, this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBitMax
    implements DrillAggFunc {
        @Param
        NullableBitHolder in;
        @Workspace
        BitHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBitHolder out;

        @Override
        public void setup() {
            this.value = new BitHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 0;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value = Math.max(this.value.value, this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 0;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BigIntMax
    implements DrillAggFunc {
        @Param
        BigIntHolder in;
        @Workspace
        BigIntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBigIntHolder out;

        @Override
        public void setup() {
            this.value = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value = Math.max(this.value.value, this.in.value);
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntMax
    implements DrillAggFunc {
        @Param
        IntHolder in;
        @Workspace
        IntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntHolder out;

        @Override
        public void setup() {
            this.value = new IntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MIN_VALUE;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value = Math.max(this.value.value, this.in.value);
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BitMax
    implements DrillAggFunc {
        @Param
        BitHolder in;
        @Workspace
        BitHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBitHolder out;

        @Override
        public void setup() {
            this.value = new BitHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 0;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value = Math.max(this.value.value, this.in.value);
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.value.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 0;
        }
    }
}

