/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import org.apache.drill.exec.util.DecimalUtility;

public class DecimalSumZeroFunctions {

    @FunctionTemplate(name="$sum0", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, returnType=FunctionTemplate.ReturnType.DECIMAL_SUM_AGGREGATE)
    public static class NullableVarDecimalSumZero
    implements DrillAggFunc {
        @Param
        NullableVarDecimalHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        IntHolder outputScale;
        @Output
        NullableVarDecimalHolder out;
        @Workspace
        BigIntHolder nonNullCount;

        @Override
        public void setup() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                BigDecimal currentValue = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale);
                this.value.obj = ((BigDecimal)this.value.obj).add(currentValue);
                if (this.outputScale.value == Integer.MIN_VALUE) {
                    this.outputScale.value = this.in.scale;
                }
                DecimalUtility.checkValueOverflow((BigDecimal)this.value.obj, DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision(), this.outputScale.value);
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.start = 0;
                this.out.scale = this.outputScale.value;
                this.out.precision = DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
                this.value.obj = ((BigDecimal)this.value.obj).setScale(this.out.scale, 4);
                byte[] bytes = ((BigDecimal)this.value.obj).unscaledValue().toByteArray();
                int len = bytes.length;
                this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
                this.out.buffer.setBytes(0, bytes);
                this.out.end = len;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="$sum0", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, returnType=FunctionTemplate.ReturnType.DECIMAL_SUM_AGGREGATE)
    public static class VarDecimalSumZero
    implements DrillAggFunc {
        @Param
        VarDecimalHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        IntHolder outputScale;
        @Output
        NullableVarDecimalHolder out;
        @Workspace
        BigIntHolder nonNullCount;

        @Override
        public void setup() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            BigDecimal currentValue = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale);
            this.value.obj = ((BigDecimal)this.value.obj).add(currentValue);
            if (this.outputScale.value == Integer.MIN_VALUE) {
                this.outputScale.value = this.in.scale;
            }
            DecimalUtility.checkValueOverflow((BigDecimal)this.value.obj, DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision(), this.outputScale.value);
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.start = 0;
                this.out.scale = this.outputScale.value;
                this.out.precision = DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
                this.value.obj = ((BigDecimal)this.value.obj).setScale(this.out.scale, 4);
                byte[] bytes = ((BigDecimal)this.value.obj).unscaledValue().toByteArray();
                int len = bytes.length;
                this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
                this.out.buffer.setBytes(0, bytes);
                this.out.end = len;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
            this.nonNullCount.value = 0L;
        }
    }
}

