/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.gaggr.AvgFunctions;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvgIntervalTypeFunctions {
    static final Logger logger = LoggerFactory.getLogger(AvgFunctions.class);

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntervalAvg
    implements DrillAggFunc {
        @Param
        NullableIntervalHolder in;
        @Workspace
        BigIntHolder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalHolder out;

        @Override
        public void setup() {
            this.sum = new BigIntHolder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.sum.value += (long)this.in.months * 30L + (long)(this.in.days * 86400000) + (long)this.in.milliseconds;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                double millis = (double)this.sum.value / (double)this.count.value;
                this.out.months = (int)(millis / 2.592E9);
                this.out.days = (int)((millis %= 2.592E9) / 8.64E7);
                this.out.milliseconds = (int)(millis % 8.64E7);
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntervalAvg
    implements DrillAggFunc {
        @Param
        IntervalHolder in;
        @Workspace
        BigIntHolder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalHolder out;

        @Override
        public void setup() {
            this.sum = new BigIntHolder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.sum.value += (long)this.in.months * 30L + (long)(this.in.days * 86400000) + (long)this.in.milliseconds;
            ++this.count.value;
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                double millis = (double)this.sum.value / (double)this.count.value;
                this.out.months = (int)(millis / 2.592E9);
                this.out.days = (int)((millis %= 2.592E9) / 8.64E7);
                this.out.milliseconds = (int)(millis % 8.64E7);
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntervalYearAvg
    implements DrillAggFunc {
        @Param
        NullableIntervalYearHolder in;
        @Workspace
        BigIntHolder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalHolder out;

        @Override
        public void setup() {
            this.sum = new BigIntHolder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.sum.value += (long)this.in.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                double millis = (double)this.sum.value / (double)this.count.value;
                this.out.months = (int)(millis / 2.592E9);
                this.out.days = (int)((millis %= 2.592E9) / 8.64E7);
                this.out.milliseconds = (int)(millis % 8.64E7);
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntervalYearAvg
    implements DrillAggFunc {
        @Param
        IntervalYearHolder in;
        @Workspace
        BigIntHolder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalHolder out;

        @Override
        public void setup() {
            this.sum = new BigIntHolder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.sum.value += (long)this.in.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                double millis = (double)this.sum.value / (double)this.count.value;
                this.out.months = (int)(millis / 2.592E9);
                this.out.days = (int)((millis %= 2.592E9) / 8.64E7);
                this.out.milliseconds = (int)(millis % 8.64E7);
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntervalDayAvg
    implements DrillAggFunc {
        @Param
        NullableIntervalDayHolder in;
        @Workspace
        BigIntHolder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalHolder out;

        @Override
        public void setup() {
            this.sum = new BigIntHolder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.sum.value += (long)this.in.days * 86400000L + (long)this.in.milliseconds;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                double millis = (double)this.sum.value / (double)this.count.value;
                this.out.months = 0;
                this.out.days = (int)(millis / 8.64E7);
                this.out.milliseconds = (int)(millis % 8.64E7);
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntervalDayAvg
    implements DrillAggFunc {
        @Param
        IntervalDayHolder in;
        @Workspace
        BigIntHolder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalHolder out;

        @Override
        public void setup() {
            this.sum = new BigIntHolder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.sum.value += (long)this.in.days * 86400000L + (long)this.in.milliseconds;
            ++this.count.value;
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                double millis = (double)this.sum.value / (double)this.count.value;
                this.out.months = 0;
                this.out.days = (int)(millis / 8.64E7);
                this.out.milliseconds = (int)(millis % 8.64E7);
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }
    }
}

