/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.conv;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;

public class RoundFunctions {

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RoundFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (Double.isNaN(this.in.value)) {
                this.out.value = 0.0;
            } else if (Double.isInfinite(this.in.value)) {
                this.out.value = Math.signum(this.in.value) > 0.0 ? 9.223372036854776E18 : -9.223372036854776E18;
            } else {
                BigDecimal input = BigDecimal.valueOf(this.in.value);
                this.out.value = input.setScale(0, RoundingMode.HALF_UP).doubleValue();
            }
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RoundFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (Float.isNaN(this.in.value)) {
                this.out.value = 0.0f;
            } else if (Float.isInfinite(this.in.value)) {
                this.out.value = Math.signum(this.in.value) > 0.0f ? 2.1474836E9f : -2.1474836E9f;
            } else {
                BigDecimal input = BigDecimal.valueOf(this.in.value);
                this.out.value = input.setScale(0, RoundingMode.HALF_UP).floatValue();
            }
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RoundUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        UInt8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RoundUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        UInt4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RoundUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        UInt2Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RoundUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        UInt1Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RoundTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        TinyIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RoundSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        SmallIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RoundBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RoundInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }
}

