/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.conv;

import io.netty.buffer.DrillBuf;
import java.io.ByteArrayOutputStream;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.vector.complex.fn.JsonWriter;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConvertTo {
    static final Logger logger = LoggerFactory.getLogger(JsonConvertTo.class);

    private JsonConvertTo() {
    }

    @FunctionTemplate(name="convert_toEXTENDEDJSON", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_FIXED_WIDTH_DEFAULT)
    public static class ConvertToExtendedJson
    implements DrillSimpleFunc {
        @Param
        FieldReader input;
        @Output
        VarBinaryHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.start = 0;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                JsonWriter jsonWriter = new JsonWriter(stream, true, true);
                jsonWriter.write(this.input);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            byte[] bytea = stream.toByteArray();
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(bytea.length);
            this.out.buffer.setBytes(0, bytea);
            this.out.end = bytea.length;
        }
    }

    @FunctionTemplate(names={"convert_toJSON", "convert_toSIMPLEJSON"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_FIXED_WIDTH_DEFAULT)
    public static class ConvertToJson
    implements DrillSimpleFunc {
        @Param
        FieldReader input;
        @Output
        VarBinaryHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.start = 0;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                JsonWriter jsonWriter = new JsonWriter(stream, true, false);
                jsonWriter.write(this.input);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            byte[] bytea = stream.toByteArray();
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(bytea.length);
            this.out.buffer.setBytes(0, bytea);
            this.out.end = bytea.length;
        }
    }
}

