/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.conv;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.vector.complex.fn.JsonReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConvertFrom {
    static final Logger logger = LoggerFactory.getLogger(JsonConvertFrom.class);

    private JsonConvertFrom() {
    }

    @FunctionTemplate(name="convert_fromJSON", scope=FunctionTemplate.FunctionScope.SIMPLE, isRandom=true)
    public static class ConvertFromJsonVarcharNullableInput
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        JsonReader jsonReader;
        @Output
        BaseWriter.ComplexWriter writer;

        @Override
        public void setup() {
            this.jsonReader = new JsonReader.Builder(this.buffer).defaultSchemaPathColumns().build();
        }

        @Override
        public void eval() {
            if (this.in.isSet == 0) {
                BaseWriter.MapWriter mapWriter = this.writer.rootAsMap();
                mapWriter.start();
                mapWriter.end();
                return;
            }
            try {
                this.jsonReader.setSource(this.in.start, this.in.end, this.in.buffer);
                this.jsonReader.write(this.writer);
                this.buffer = this.jsonReader.getWorkBuf();
            }
            catch (Exception e) {
                throw new DrillRuntimeException("Error while converting from JSON. ", e);
            }
        }
    }

    @FunctionTemplate(name="convert_fromJSON", scope=FunctionTemplate.FunctionScope.SIMPLE, isRandom=true)
    public static class ConvertFromJsonNullableInput
    implements DrillSimpleFunc {
        @Param
        NullableVarBinaryHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        JsonReader jsonReader;
        @Output
        BaseWriter.ComplexWriter writer;

        @Override
        public void setup() {
            this.jsonReader = new JsonReader.Builder(this.buffer).defaultSchemaPathColumns().build();
        }

        @Override
        public void eval() {
            if (this.in.isSet == 0) {
                BaseWriter.MapWriter mapWriter = this.writer.rootAsMap();
                mapWriter.start();
                mapWriter.end();
                return;
            }
            try {
                this.jsonReader.setSource(this.in.start, this.in.end, this.in.buffer);
                this.jsonReader.write(this.writer);
                this.buffer = this.jsonReader.getWorkBuf();
            }
            catch (Exception e) {
                throw new DrillRuntimeException("Error while converting from JSON. ", e);
            }
        }
    }

    @FunctionTemplate(name="convert_fromJSON", scope=FunctionTemplate.FunctionScope.SIMPLE, isRandom=true)
    public static class ConvertFromJsonVarchar
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        JsonReader jsonReader;
        @Output
        BaseWriter.ComplexWriter writer;

        @Override
        public void setup() {
            this.jsonReader = new JsonReader.Builder(this.buffer).defaultSchemaPathColumns().build();
        }

        @Override
        public void eval() {
            try {
                this.jsonReader.setSource(this.in.start, this.in.end, this.in.buffer);
                this.jsonReader.write(this.writer);
                this.buffer = this.jsonReader.getWorkBuf();
            }
            catch (Exception e) {
                throw new DrillRuntimeException("Error while converting from JSON. ", e);
            }
        }
    }

    @FunctionTemplate(name="convert_fromJSON", scope=FunctionTemplate.FunctionScope.SIMPLE, isRandom=true)
    public static class ConvertFromJson
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        JsonReader jsonReader;
        @Output
        BaseWriter.ComplexWriter writer;

        @Override
        public void setup() {
            this.jsonReader = new JsonReader.Builder(this.buffer).defaultSchemaPathColumns().build();
        }

        @Override
        public void eval() {
            try {
                this.jsonReader.setSource(this.in.start, this.in.end, this.in.buffer);
                this.jsonReader.write(this.writer);
                this.buffer = this.jsonReader.getWorkBuf();
            }
            catch (Exception e) {
                throw new DrillRuntimeException("Error while converting from JSON. ", e);
            }
        }
    }
}

