/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import io.netty.util.internal.PlatformDependent;
import org.apache.drill.exec.expr.fn.impl.DrillHash;
import org.apache.drill.exec.memory.BoundsChecking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XXHash
extends DrillHash {
    static final Logger logger = LoggerFactory.getLogger(XXHash.class);
    static final long PRIME64_1 = -7046029288634856825L;
    static final long PRIME64_2 = -4417276706812531889L;
    static final long PRIME64_3 = 1609587929392839161L;
    static final long PRIME64_4 = -8796714831421723037L;
    static final long PRIME64_5 = 2870177450012600261L;

    private static long hash64bytes(long start, long bEnd, long seed) {
        long h64;
        long len = bEnd - start;
        long p = start;
        if (len >= 32L) {
            long limit = bEnd - 32L;
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed + 0L;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 += PlatformDependent.getLong(p) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += PlatformDependent.getLong(p += 8L) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += PlatformDependent.getLong(p += 8L) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += PlatformDependent.getLong(p += 8L) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
            } while ((p += 8L) <= limit);
            h64 = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            h64 ^= (v1 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            h64 ^= (v2 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            h64 ^= (v3 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            h64 ^= (v4 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
        } else {
            h64 = seed + 2870177450012600261L;
        }
        h64 += len;
        while (p + 8L <= bEnd) {
            long k1 = PlatformDependent.getLong(p);
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            h64 ^= (k1 *= -7046029288634856825L);
            h64 = Long.rotateLeft(h64, 27) * -7046029288634856825L + -8796714831421723037L;
            p += 8L;
        }
        if (p + 4L <= bEnd) {
            long finalInt = XXHash.getIntLittleEndian(p);
            h64 ^= finalInt * -7046029288634856825L;
            h64 = Long.rotateLeft(h64, 23) * -4417276706812531889L + 1609587929392839161L;
            p += 4L;
        }
        while (p < bEnd) {
            h64 ^= (long)(PlatformDependent.getByte(p) & 0xFF) * 2870177450012600261L;
            h64 = Long.rotateLeft(h64, 11) * -7046029288634856825L;
            ++p;
        }
        return XXHash.applyFinalHashComputation(h64);
    }

    private static long applyFinalHashComputation(long h64) {
        h64 ^= h64 >>> 33;
        h64 *= -4417276706812531889L;
        h64 ^= h64 >>> 29;
        h64 *= 1609587929392839161L;
        h64 ^= h64 >>> 32;
        return h64;
    }

    public static long hash64Internal(long val, long seed) {
        long h64 = seed + 2870177450012600261L;
        h64 += 8L;
        long k1 = val * -4417276706812531889L;
        k1 = Long.rotateLeft(k1, 31);
        h64 ^= (k1 *= -7046029288634856825L);
        h64 = Long.rotateLeft(h64, 27) * -7046029288634856825L + -8796714831421723037L;
        return XXHash.applyFinalHashComputation(h64);
    }

    private static int convert64To32(long val) {
        return (int)(val & 0xFFFFFFFFFFFFFFFFL);
    }

    public static long hash64(double val, long seed) {
        return XXHash.hash64Internal(Double.doubleToLongBits(val), seed);
    }

    public static long hash64(long start, long end, DrillBuf buffer, long seed) {
        BoundsChecking.rangeCheck(buffer, (int)start, (int)end);
        long s = buffer.memoryAddress() + start;
        long e = buffer.memoryAddress() + end;
        return XXHash.hash64bytes(s, e, seed);
    }

    public static int hash32(double val, long seed) {
        return XXHash.convert64To32(XXHash.hash64(val, seed));
    }

    public static int hash32(int start, int end, DrillBuf buffer, int seed) {
        return XXHash.convert64To32(XXHash.hash64(start, end, buffer, seed));
    }
}

