/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.planner.types.decimal.DecimalScalePrecisionAddFunction;
import org.apache.drill.exec.planner.types.decimal.DecimalScalePrecisionDivideFunction;
import org.apache.drill.exec.planner.types.decimal.DecimalScalePrecisionModFunction;
import org.apache.drill.exec.planner.types.decimal.DecimalScalePrecisionMulFunction;
import org.apache.drill.exec.util.DecimalUtility;

public class VarDecimalFunctions {

    @FunctionTemplate(name="not_equal", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalNotEqual
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false);
            this.out.value = cmp != 0 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="equal", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalEqual
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false);
            this.out.value = cmp == 0 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="greater_than_or_equal_to", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalGreaterThanEq
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false);
            this.out.value = cmp > -1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="greater_than", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalGreaterThan
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false);
            this.out.value = cmp == 1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="less_than_or_equal_to", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalLessThanEq
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false);
            this.out.value = cmp < 1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="less_than", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalLessThan
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false);
            this.out.value = cmp == -1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareVarDecimalVsVarDecimalNullLow
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareVarDecimalVsVarDecimalNullHigh
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareVarDecimalVsNullableVarDecimalNullLow
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        NullableVarDecimalHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.isSet == 0 ? 1 : DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareVarDecimalVsNullableVarDecimalNullHigh
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        NullableVarDecimalHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.isSet == 0 ? -1 : DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableVarDecimalVsVarDecimalNullLow
    implements DrillSimpleFunc {
        @Param
        NullableVarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? -1 : DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableVarDecimalVsVarDecimalNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableVarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? 1 : DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableVarDecimalVsNullableVarDecimalNullLow
    implements DrillSimpleFunc {
        @Param
        NullableVarDecimalHolder left;
        @Param
        NullableVarDecimalHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : -1) : (this.right.isSet == 0 ? 1 : DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableVarDecimalVsNullableVarDecimalNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableVarDecimalHolder left;
        @Param
        NullableVarDecimalHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : 1) : (this.right.isSet == 0 ? -1 : DecimalUtility.compareVarLenBytes(this.left.buffer, this.left.start, this.left.end, this.left.scale, this.right.buffer, this.right.start, this.right.end, this.right.scale, false));
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_SET_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalRoundScaleFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        IntHolder right;
        @Output
        VarDecimalHolder result;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.result.scale = Math.max(this.right.value, 0);
            this.result.precision = this.left.precision;
            this.result.start = 0;
            BigDecimal bd = DecimalUtility.getBigDecimalFromDrillBuf(this.left.buffer, this.left.start, this.left.end - this.left.start, this.left.scale).setScale(this.result.scale, 4);
            byte[] bytes = bd.unscaledValue().toByteArray();
            int len = bytes.length;
            this.result.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            this.result.buffer.setBytes(0, bytes);
            this.result.end = len;
        }
    }

    @FunctionTemplate(names={"trunc", "truncate"}, scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_SET_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalTruncateScaleFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        IntHolder right;
        @Output
        VarDecimalHolder result;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.result.start = 0;
            this.result.scale = Math.max(this.right.value, 0);
            this.result.precision = this.left.precision;
            BigDecimal opResult = DecimalUtility.getBigDecimalFromDrillBuf(this.left.buffer, this.left.start, this.left.end - this.left.start, this.left.scale).setScale(this.result.scale, 1);
            byte[] bytes = opResult.unscaledValue().toByteArray();
            int len = bytes.length;
            this.result.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            this.result.buffer.setBytes(0, bytes);
            this.result.end = len;
        }
    }

    @FunctionTemplate(name="sign", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalSignFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal bd = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale);
            this.out.value = bd.signum();
        }
    }

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalNegativeFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder in;
        @Output
        VarDecimalHolder result;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.result.start = 0;
            this.result.precision = this.in.precision;
            BigDecimal opResult = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale).negate();
            this.result.scale = this.in.scale;
            byte[] bytes = opResult.unscaledValue().toByteArray();
            int len = bytes.length;
            this.result.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            this.result.buffer.setBytes(0, bytes);
            this.result.end = len;
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_ZERO_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalRoundFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder in;
        @Output
        VarDecimalHolder result;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.result.start = 0;
            this.result.precision = this.in.precision;
            BigDecimal opResult = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale).setScale(0, 4);
            byte[] bytes = opResult.unscaledValue().toByteArray();
            int len = bytes.length;
            this.result.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            this.result.buffer.setBytes(0, bytes);
            this.result.end = len;
        }
    }

    @FunctionTemplate(names={"trunc", "truncate"}, scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_ZERO_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalTruncFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder in;
        @Output
        VarDecimalHolder result;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.result.start = 0;
            this.result.precision = this.in.precision;
            BigDecimal opResult = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale).setScale(0, 1);
            byte[] bytes = opResult.unscaledValue().toByteArray();
            int len = bytes.length;
            this.result.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            this.result.buffer.setBytes(0, bytes);
            this.result.end = len;
        }
    }

    @FunctionTemplate(name="floor", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_ZERO_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalFloorFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder in;
        @Output
        VarDecimalHolder result;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.result.start = 0;
            this.result.precision = this.in.precision;
            BigDecimal opResult = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale).setScale(0, 3);
            byte[] bytes = opResult.unscaledValue().toByteArray();
            int len = bytes.length;
            this.result.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            this.result.buffer.setBytes(0, bytes);
            this.result.end = len;
        }
    }

    @FunctionTemplate(names={"ceil", "ceiling"}, scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_ZERO_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalCeilFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder in;
        @Output
        VarDecimalHolder result;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.result.start = 0;
            this.result.precision = this.in.precision;
            BigDecimal opResult = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale).setScale(0, 2);
            byte[] bytes = opResult.unscaledValue().toByteArray();
            int len = bytes.length;
            this.result.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            this.result.buffer.setBytes(0, bytes);
            this.result.end = len;
        }
    }

    @FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class VarDecimalAbsFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder in;
        @Output
        VarDecimalHolder result;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.result.start = 0;
            this.result.precision = this.in.precision;
            BigDecimal opResult = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale).abs();
            this.result.scale = this.in.scale;
            byte[] bytes = opResult.unscaledValue().toByteArray();
            int len = bytes.length;
            this.result.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            this.result.buffer.setBytes(0, bytes);
            this.result.end = len;
        }
    }

    @FunctionTemplate(name="mod", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_MOD_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, checkPrecisionRange=true)
    public static class VarDecimalModFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Inject
        DrillBuf buffer;
        @Output
        VarDecimalHolder result;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.result.start = 0;
            BigDecimal leftInput = DecimalUtility.getBigDecimalFromDrillBuf(this.left.buffer, this.left.start, this.left.end - this.left.start, this.left.scale);
            BigDecimal rightInput = DecimalUtility.getBigDecimalFromDrillBuf(this.right.buffer, this.right.start, this.right.end - this.right.start, this.right.scale);
            DecimalScalePrecisionModFunction typeInference = new DecimalScalePrecisionModFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
            this.result.scale = typeInference.getOutputScale();
            this.result.precision = typeInference.getOutputPrecision();
            BigDecimal opResult = leftInput.remainder(rightInput, new MathContext(this.result.precision, RoundingMode.HALF_UP)).setScale(this.result.scale, 4);
            DecimalUtility.checkValueOverflow(opResult, this.result.precision, this.result.scale);
            byte[] bytes = opResult.unscaledValue().toByteArray();
            int len = bytes.length;
            this.result.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            this.result.buffer.setBytes(0, bytes);
            this.result.end = len;
        }
    }

    @FunctionTemplate(name="divide", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_DIV_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, checkPrecisionRange=true)
    public static class VarDecimalDivideFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Inject
        DrillBuf buffer;
        @Output
        VarDecimalHolder result;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.result.start = 0;
            BigDecimal leftInput = DecimalUtility.getBigDecimalFromDrillBuf(this.left.buffer, this.left.start, this.left.end - this.left.start, this.left.scale);
            BigDecimal rightInput = DecimalUtility.getBigDecimalFromDrillBuf(this.right.buffer, this.right.start, this.right.end - this.right.start, this.right.scale);
            DecimalScalePrecisionDivideFunction typeInference = new DecimalScalePrecisionDivideFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
            this.result.scale = typeInference.getOutputScale();
            this.result.precision = typeInference.getOutputPrecision();
            BigDecimal opResult = leftInput.divide(rightInput, new MathContext(this.result.precision, RoundingMode.HALF_UP)).setScale(this.result.scale, 4);
            DecimalUtility.checkValueOverflow(opResult, this.result.precision, this.result.scale);
            byte[] bytes = opResult.unscaledValue().toByteArray();
            int len = bytes.length;
            this.result.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            this.result.buffer.setBytes(0, bytes);
            this.result.end = len;
        }
    }

    @FunctionTemplate(name="multiply", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_SUM_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, checkPrecisionRange=true)
    public static class VarDecimalMultiplyFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Inject
        DrillBuf buffer;
        @Output
        VarDecimalHolder result;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.result.start = 0;
            BigDecimal leftInput = DecimalUtility.getBigDecimalFromDrillBuf(this.left.buffer, this.left.start, this.left.end - this.left.start, this.left.scale);
            BigDecimal rightInput = DecimalUtility.getBigDecimalFromDrillBuf(this.right.buffer, this.right.start, this.right.end - this.right.start, this.right.scale);
            DecimalScalePrecisionMulFunction typeInference = new DecimalScalePrecisionMulFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
            this.result.scale = typeInference.getOutputScale();
            this.result.precision = typeInference.getOutputPrecision();
            BigDecimal opResult = leftInput.multiply(rightInput, new MathContext(this.result.precision, RoundingMode.HALF_UP)).setScale(this.result.scale, 4);
            DecimalUtility.checkValueOverflow(opResult, this.result.precision, this.result.scale);
            byte[] bytes = opResult.unscaledValue().toByteArray();
            int len = bytes.length;
            this.result.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            this.result.buffer.setBytes(0, bytes);
            this.result.end = len;
        }
    }

    @FunctionTemplate(name="add", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_ADD_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, checkPrecisionRange=true)
    public static class VarDecimalAddFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Inject
        DrillBuf buffer;
        @Output
        VarDecimalHolder result;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.result.start = 0;
            BigDecimal leftInput = DecimalUtility.getBigDecimalFromDrillBuf(this.left.buffer, this.left.start, this.left.end - this.left.start, this.left.scale);
            BigDecimal rightInput = DecimalUtility.getBigDecimalFromDrillBuf(this.right.buffer, this.right.start, this.right.end - this.right.start, this.right.scale);
            DecimalScalePrecisionAddFunction typeInference = new DecimalScalePrecisionAddFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
            this.result.scale = typeInference.getOutputScale();
            this.result.precision = typeInference.getOutputPrecision();
            BigDecimal opResult = leftInput.add(rightInput, new MathContext(this.result.precision, RoundingMode.HALF_UP)).setScale(this.result.scale, 4);
            DecimalUtility.checkValueOverflow(opResult, this.result.precision, this.result.scale);
            byte[] bytes = opResult.unscaledValue().toByteArray();
            int len = bytes.length;
            this.result.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            this.result.buffer.setBytes(0, bytes);
            this.result.end = len;
        }
    }

    @FunctionTemplate(name="subtract", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_ADD_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, checkPrecisionRange=true)
    public static class VarDecimalSubtractFunction
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder left;
        @Param
        VarDecimalHolder right;
        @Inject
        DrillBuf buffer;
        @Output
        VarDecimalHolder result;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.result.start = 0;
            BigDecimal leftInput = DecimalUtility.getBigDecimalFromDrillBuf(this.left.buffer, this.left.start, this.left.end - this.left.start, this.left.scale);
            BigDecimal rightInput = DecimalUtility.getBigDecimalFromDrillBuf(this.right.buffer, this.right.start, this.right.end - this.right.start, this.right.scale);
            DecimalScalePrecisionAddFunction typeInference = new DecimalScalePrecisionAddFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
            this.result.scale = typeInference.getOutputScale();
            this.result.precision = typeInference.getOutputPrecision();
            BigDecimal opResult = leftInput.subtract(rightInput, new MathContext(this.result.precision, RoundingMode.HALF_UP)).setScale(this.result.scale, 4);
            DecimalUtility.checkValueOverflow(opResult, this.result.precision, this.result.scale);
            byte[] bytes = opResult.unscaledValue().toByteArray();
            int len = bytes.length;
            this.result.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            this.result.buffer.setBytes(0, bytes);
            this.result.end = len;
        }
    }
}

