/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public class TypeFunctions {

    @FunctionTemplate(name="modeOf", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GetMode
    implements DrillSimpleFunc {
        @Param
        FieldReader input;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            String typeName = Types.getSqlModeName(this.input.getType());
            byte[] type = typeName.getBytes(StandardCharsets.UTF_8);
            this.buf = this.buf.reallocIfNeeded(type.length);
            this.buf.setBytes(0, type);
            this.out.buffer = this.buf;
            this.out.start = 0;
            this.out.end = type.length;
        }
    }

    @FunctionTemplate(name="drillTypeOf", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GetDrillType
    implements DrillSimpleFunc {
        @Param
        FieldReader input;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            String typeName = this.input.getVectorType().name();
            byte[] type = typeName.getBytes(StandardCharsets.UTF_8);
            this.buf = this.buf.reallocIfNeeded(type.length);
            this.buf.setBytes(0, type);
            this.out.buffer = this.buf;
            this.out.start = 0;
            this.out.end = type.length;
        }
    }

    @FunctionTemplate(name="sqlTypeOf", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GetSqlType
    implements DrillSimpleFunc {
        @Param
        FieldReader input;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            String typeName = Types.getExtendedSqlTypeName(this.input.getType());
            byte[] type = typeName.getBytes(StandardCharsets.UTF_8);
            this.buf = this.buf.reallocIfNeeded(type.length);
            this.buf.setBytes(0, type);
            this.out.buffer = this.buf;
            this.out.start = 0;
            this.out.end = type.length;
        }
    }
}

