/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import com.tdunning.math.stats.MergingDigest;
import com.tdunning.math.stats.TDigest;
import io.netty.buffer.DrillBuf;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.server.options.OptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDigestFunctions {
    static final Logger logger = LoggerFactory.getLogger(TDigestFunctions.class);

    private TDigestFunctions() {
    }

    @FunctionTemplate(name="tdigest_merge", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TDigestMergeFunction
    implements DrillAggFunc {
        @Param
        NullableVarBinaryHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (this.in.isSet != 0) {
                        byte[] buf = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes(StandardCharsets.UTF_8);
                        MergingDigest other = MergingDigest.fromBytes((ByteBuffer)ByteBuffer.wrap(buf));
                        tdigest.add((TDigest)other);
                    }
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to merge TDigest output", e);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    int size = tdigest.smallByteSize();
                    ByteBuffer byteBuf = ByteBuffer.allocate(size);
                    tdigest.asSmallBytes(byteBuf);
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                    this.out.start = 0;
                    this.out.end = size;
                    this.out.buffer.setBytes(0, byteBuf.array());
                    this.out.isSet = 1;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarBinaryTDigestFunction
    implements DrillAggFunc {
        @Param
        NullableVarBinaryHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
        }

        @Override
        public void add() {
        }

        @Override
        public void output() {
        }

        @Override
        public void reset() {
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarBinaryTDigestFunction
    implements DrillAggFunc {
        @Param
        VarBinaryHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
        }

        @Override
        public void add() {
        }

        @Override
        public void output() {
        }

        @Override
        public void reset() {
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarCharTDigestFunction
    implements DrillAggFunc {
        @Param
        NullableVarCharHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
        }

        @Override
        public void add() {
        }

        @Override
        public void output() {
        }

        @Override
        public void reset() {
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarCharTDigestFunction
    implements DrillAggFunc {
        @Param
        VarCharHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
        }

        @Override
        public void add() {
        }

        @Override
        public void output() {
        }

        @Override
        public void reset() {
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTimeStampTDigestFunction
    implements DrillAggFunc {
        @Param
        NullableTimeStampHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                if (this.in.isSet == 1) {
                    tdigest.add((double)this.in.value);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TimeStampTDigestFunction
    implements DrillAggFunc {
        @Param
        TimeStampHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                tdigest.add((double)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTimeTDigestFunction
    implements DrillAggFunc {
        @Param
        NullableTimeHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                if (this.in.isSet == 1) {
                    tdigest.add((double)this.in.value);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TimeTDigestFunction
    implements DrillAggFunc {
        @Param
        TimeHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                tdigest.add((double)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDateTDigestFunction
    implements DrillAggFunc {
        @Param
        NullableDateHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                if (this.in.isSet == 1) {
                    tdigest.add((double)this.in.value);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class DateTDigestFunction
    implements DrillAggFunc {
        @Param
        DateHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                tdigest.add((double)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBitTDigestFunction
    implements DrillAggFunc {
        @Param
        NullableBitHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                if (this.in.isSet == 1) {
                    tdigest.add((double)this.in.value);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BitTDigestFunction
    implements DrillAggFunc {
        @Param
        BitHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                tdigest.add((double)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat4TDigestFunction
    implements DrillAggFunc {
        @Param
        NullableFloat4Holder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                if (this.in.isSet == 1) {
                    tdigest.add((double)this.in.value);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float4TDigestFunction
    implements DrillAggFunc {
        @Param
        Float4Holder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                tdigest.add((double)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat8TDigestFunction
    implements DrillAggFunc {
        @Param
        NullableFloat8Holder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                if (this.in.isSet == 1) {
                    tdigest.add(this.in.value);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float8TDigestFunction
    implements DrillAggFunc {
        @Param
        Float8Holder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                tdigest.add(this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntTDigestFunction
    implements DrillAggFunc {
        @Param
        NullableIntHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                if (this.in.isSet == 1) {
                    tdigest.add((double)this.in.value);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntTDigestFunction
    implements DrillAggFunc {
        @Param
        IntHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                tdigest.add((double)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBigIntTDigestFunction
    implements DrillAggFunc {
        @Param
        NullableBigIntHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                if (this.in.isSet == 1) {
                    tdigest.add((double)this.in.value);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }

    @FunctionTemplate(name="tdigest", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BigIntTDigestFunction
    implements DrillAggFunc {
        @Param
        BigIntHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder compression;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.compression.value = (int)this.options.getLong("exec.statistics.tdigest_compression");
            this.work.obj = new MergingDigest((double)this.compression.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                tdigest.add((double)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                MergingDigest tdigest = (MergingDigest)this.work.obj;
                try {
                    if (tdigest.size() > 0L) {
                        int size = tdigest.smallByteSize();
                        ByteBuffer byteBuf = ByteBuffer.allocate(size);
                        tdigest.asSmallBytes(byteBuf);
                        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(size);
                        this.out.start = 0;
                        this.out.end = size;
                        this.out.buffer.setBytes(0, byteBuf.array());
                        this.out.isSet = 1;
                    }
                    this.out.isSet = 0;
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to get TDigest output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new MergingDigest((double)this.compression.value);
        }
    }
}

