/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.ByteBuf;
import org.apache.drill.common.exceptions.DrillRuntimeException;

public class StringFunctionUtil {
    public static int getUTF8CharLength(ByteBuf buffer, int start, int end) {
        int charCount = 0;
        int charLen = 0;
        for (int idx = start; idx < end; idx += charLen) {
            charLen = StringFunctionUtil.utf8CharLen(buffer, idx);
            ++charCount;
        }
        return charCount;
    }

    public static int getUTF8CharPosition(ByteBuf buffer, int start, int end, int charLength) {
        int charCount = 0;
        if (start >= end) {
            return -1;
        }
        int charLen = 0;
        for (int idx = start; idx < end; idx += charLen) {
            charLen = StringFunctionUtil.utf8CharLen(buffer, idx);
            if (++charCount != charLength + 1) continue;
            return idx;
        }
        return end;
    }

    public static int stringLeftMatchUTF8(ByteBuf str, int strStart, int strEnd, ByteBuf substr, int subStart, int subEnd) {
        for (int i = strStart; i <= strEnd - (subEnd - subStart); ++i) {
            int j;
            for (j = subStart; j < subEnd && str.getByte(i + j - subStart) == substr.getByte(j); ++j) {
            }
            if (j != subEnd || j == subStart) continue;
            return i;
        }
        return -1;
    }

    public static int utf8CharLen(ByteBuf buffer, int idx) {
        byte firstByte = buffer.getByte(idx);
        if (firstByte >= 0) {
            return 1;
        }
        if ((firstByte & 0xE0) == 192) {
            return 2;
        }
        if ((firstByte & 0xF0) == 224) {
            return 3;
        }
        if ((firstByte & 0xF8) == 240) {
            return 4;
        }
        throw new DrillRuntimeException("Unexpected byte 0x" + Integer.toString(firstByte & 0xFF, 16) + " at position " + idx + " encountered while decoding UTF8 string.");
    }

    public static int utf8CharLen(byte currentByte) {
        if (currentByte >= 0) {
            return 1;
        }
        if ((currentByte & 0xE0) == 192) {
            return 2;
        }
        if ((currentByte & 0xF0) == 224) {
            return 3;
        }
        if ((currentByte & 0xF8) == 240) {
            return 4;
        }
        throw new DrillRuntimeException("Unexpected byte 0x" + Integer.toString(currentByte & 0xFF, 16) + " encountered while decoding UTF8 string.");
    }
}

