/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import com.google.common.base.Charsets;
import io.netty.buffer.DrillBuf;
import io.netty.util.internal.PlatformDependent;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.memory.BoundsChecking;
import org.joda.time.chrono.ISOChronology;

public class StringFunctionHelpers {
    static final int RADIX = 10;
    static final long MAX_LONG = -922337203685477580L;
    static final int MAX_INT = -214748364;
    private static final ISOChronology CHRONOLOGY = ISOChronology.getInstanceUTC();

    public static long varTypesToLong(int start, int end, DrillBuf buffer) {
        boolean negative;
        if (end - start == 0) {
            throw StringFunctionHelpers.nfeL(start, end, buffer);
        }
        int readIndex = start;
        boolean bl = negative = buffer.getByte(readIndex) == 45;
        if (negative && ++readIndex == end) {
            throw StringFunctionHelpers.nfeL(start, end, buffer);
        }
        long result = 0L;
        while (readIndex < end) {
            int digit;
            if ((digit = Character.digit(buffer.getByte(readIndex++), 10)) == -1) {
                throw StringFunctionHelpers.nfeL(start, end, buffer);
            }
            if (-922337203685477580L > result) {
                throw StringFunctionHelpers.nfeL(start, end, buffer);
            }
            long next = result * 10L - (long)digit;
            if (next > result) {
                throw StringFunctionHelpers.nfeL(start, end, buffer);
            }
            result = next;
        }
        if (!negative && (result = -result) < 0L) {
            throw StringFunctionHelpers.nfeL(start, end, buffer);
        }
        return result;
    }

    private static NumberFormatException nfeL(int start, int end, DrillBuf buffer) {
        byte[] buf = new byte[end - start];
        buffer.getBytes(start, buf, 0, end - start);
        return new NumberFormatException(new String(buf, Charsets.UTF_8));
    }

    private static NumberFormatException nfeI(int start, int end, DrillBuf buffer) {
        byte[] buf = new byte[end - start];
        buffer.getBytes(start, buf, 0, end - start);
        return new NumberFormatException(new String(buf, Charsets.UTF_8));
    }

    public static int varTypesToInt(int start, int end, DrillBuf buffer) {
        boolean negative;
        if (end - start == 0) {
            throw StringFunctionHelpers.nfeI(start, end, buffer);
        }
        int readIndex = start;
        boolean bl = negative = buffer.getByte(readIndex) == 45;
        if (negative && ++readIndex == end) {
            throw StringFunctionHelpers.nfeI(start, end, buffer);
        }
        int result = 0;
        while (readIndex < end) {
            int digit;
            if ((digit = Character.digit(buffer.getByte(readIndex++), 10)) == -1) {
                throw StringFunctionHelpers.nfeI(start, end, buffer);
            }
            if (-214748364 > result) {
                throw StringFunctionHelpers.nfeI(start, end, buffer);
            }
            int next = result * 10 - digit;
            if (next > result) {
                throw StringFunctionHelpers.nfeI(start, end, buffer);
            }
            result = next;
        }
        if (!negative && (result = -result) < 0) {
            throw StringFunctionHelpers.nfeI(start, end, buffer);
        }
        return result;
    }

    public static String initCap(String source) {
        boolean capitalizeNext = true;
        StringBuilder str = new StringBuilder(source);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                str.setCharAt(i, capitalizeNext ? Character.toUpperCase(c) : Character.toLowerCase(c));
                capitalizeNext = false;
                continue;
            }
            capitalizeNext = true;
        }
        return str.toString();
    }

    public static String getStringFromVarCharHolder(VarCharHolder varCharHolder) {
        return StringFunctionHelpers.toStringFromUTF8(varCharHolder.start, varCharHolder.end, varCharHolder.buffer);
    }

    public static String getStringFromVarCharHolder(NullableVarCharHolder varCharHolder) {
        return StringFunctionHelpers.toStringFromUTF8(varCharHolder.start, varCharHolder.end, varCharHolder.buffer);
    }

    public static String toStringFromUTF8(int start, int end, DrillBuf buffer) {
        byte[] buf = new byte[end - start];
        buffer.getBytes(start, buf, 0, end - start);
        String s = new String(buf, org.apache.drill.shaded.guava.com.google.common.base.Charsets.UTF_8);
        return s;
    }

    public static String toStringFromUTF16(int start, int end, DrillBuf buffer) {
        byte[] buf = new byte[end - start];
        buffer.getBytes(start, buf, 0, end - start);
        return new String(buf, org.apache.drill.shaded.guava.com.google.common.base.Charsets.UTF_16);
    }

    public static long getDate(DrillBuf buf, int start, int end) {
        BoundsChecking.rangeCheck(buf, start, end);
        int[] dateFields = StringFunctionHelpers.memGetDate(buf.memoryAddress(), start, end);
        return CHRONOLOGY.getDateTimeMillis(dateFields[0], dateFields[1], dateFields[2], 0);
    }

    public static boolean isReadableAsDate(DrillBuf buf, int start, int end) {
        try {
            StringFunctionHelpers.getDate(buf, start, end);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private static int[] memGetDate(long memoryAddress, int start, int end) {
        long index = memoryAddress + (long)start;
        long endIndex = memoryAddress + (long)end;
        int digit = 0;
        int[] dateFields = new int[3];
        int dateIndex = 0;
        int value = 0;
        while (dateIndex < 3 && index < endIndex) {
            if ((digit = Character.digit(PlatformDependent.getByte(index++), 10)) == -1) {
                dateFields[dateIndex++] = value;
                value = 0;
                continue;
            }
            value = value * 10 + digit;
        }
        if (dateIndex < 3) {
            dateFields[dateIndex++] = value;
        }
        if (dateFields[0] < 100) {
            dateFields[0] = dateFields[0] < 70 ? dateFields[0] + 2000 : dateFields[0] + 1900;
        }
        return dateFields;
    }
}

