/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.clearspring.analytics.stream.membership.BloomFilter;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal28DenseHolder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal38DenseHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal18Holder;
import org.apache.drill.exec.expr.holders.NullableDecimal28DenseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38DenseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsAggrFunctions {
    static final Logger logger = LoggerFactory.getLogger(StatisticsAggrFunctions.class);

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarBinaryCntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableVarBinaryHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1) {
                    byte[] buf = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes();
                    if (!filter.isPresent(buf)) {
                        filter.add(buf);
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarBinaryCntDupsFunction
    implements DrillAggFunc {
        @Param
        VarBinaryHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                byte[] buf = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes();
                if (!filter.isPresent(buf)) {
                    filter.add(buf);
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVar16CharCntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableVar16CharHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1) {
                    byte[] buf = StringFunctionHelpers.toStringFromUTF16(this.in.start, this.in.end, this.in.buffer).getBytes();
                    if (!filter.isPresent(buf)) {
                        filter.add(buf);
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Var16CharCntDupsFunction
    implements DrillAggFunc {
        @Param
        Var16CharHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                byte[] buf = StringFunctionHelpers.toStringFromUTF16(this.in.start, this.in.end, this.in.buffer).getBytes();
                if (!filter.isPresent(buf)) {
                    filter.add(buf);
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarCharCntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableVarCharHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1) {
                    byte[] buf = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes();
                    if (!filter.isPresent(buf)) {
                        filter.add(buf);
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarCharCntDupsFunction
    implements DrillAggFunc {
        @Param
        VarCharHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                byte[] buf = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes();
                if (!filter.isPresent(buf)) {
                    filter.add(buf);
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntervalCntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableIntervalHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Workspace
        ObjectHolder interval;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.interval = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
            this.interval.obj = new int[3];
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1 && this.interval.obj != null) {
                    ((int[])this.interval.obj)[0] = this.in.days;
                    ((int[])this.interval.obj)[1] = this.in.months;
                    ((int[])this.interval.obj)[2] = this.in.milliseconds;
                    if (!filter.isPresent(String.valueOf(this.interval.obj))) {
                        filter.add(String.valueOf(this.interval.obj));
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
            this.interval.obj = new int[3];
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntervalCntDupsFunction
    implements DrillAggFunc {
        @Param
        IntervalHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Workspace
        ObjectHolder interval;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.interval = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
            this.interval.obj = new int[3];
        }

        @Override
        public void add() {
            if (this.work.obj != null && this.interval.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                ((int[])this.interval.obj)[0] = this.in.days;
                ((int[])this.interval.obj)[1] = this.in.months;
                ((int[])this.interval.obj)[2] = this.in.milliseconds;
                if (!filter.isPresent(String.valueOf(this.interval.obj))) {
                    filter.add(String.valueOf(this.interval.obj));
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
            this.interval.obj = new int[3];
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTimeStampCntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableTimeStampHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1) {
                    if (!filter.isPresent(String.valueOf(this.in.value))) {
                        filter.add(String.valueOf(this.in.value));
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TimeStampCntDupsFunction
    implements DrillAggFunc {
        @Param
        TimeStampHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (!filter.isPresent(String.valueOf(this.in.value))) {
                    filter.add(String.valueOf(this.in.value));
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTimeCntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableTimeHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1) {
                    if (!filter.isPresent(String.valueOf(this.in.value))) {
                        filter.add(String.valueOf(this.in.value));
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TimeCntDupsFunction
    implements DrillAggFunc {
        @Param
        TimeHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (!filter.isPresent(String.valueOf(this.in.value))) {
                    filter.add(String.valueOf(this.in.value));
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDateCntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableDateHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1) {
                    if (!filter.isPresent(String.valueOf(this.in.value))) {
                        filter.add(String.valueOf(this.in.value));
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class DateCntDupsFunction
    implements DrillAggFunc {
        @Param
        DateHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (!filter.isPresent(String.valueOf(this.in.value))) {
                    filter.add(String.valueOf(this.in.value));
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal18CntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal18Holder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1) {
                    if (!filter.isPresent(String.valueOf(this.in.value))) {
                        filter.add(String.valueOf(this.in.value));
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal18CntDupsFunction
    implements DrillAggFunc {
        @Param
        Decimal18Holder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (!filter.isPresent(String.valueOf(this.in.value))) {
                    filter.add(String.valueOf(this.in.value));
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal9CntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal9Holder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1) {
                    if (!filter.isPresent(String.valueOf(this.in.value))) {
                        filter.add(String.valueOf(this.in.value));
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal9CntDupsFunction
    implements DrillAggFunc {
        @Param
        Decimal9Holder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (!filter.isPresent(String.valueOf(this.in.value))) {
                    filter.add(String.valueOf(this.in.value));
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat8CntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableFloat8Holder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1) {
                    if (!filter.isPresent(String.valueOf(this.in.value))) {
                        filter.add(String.valueOf(this.in.value));
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float8CntDupsFunction
    implements DrillAggFunc {
        @Param
        Float8Holder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (!filter.isPresent(String.valueOf(this.in.value))) {
                    filter.add(String.valueOf(this.in.value));
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat4CntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableFloat4Holder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1) {
                    if (!filter.isPresent(String.valueOf(this.in.value))) {
                        filter.add(String.valueOf(this.in.value));
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float4CntDupsFunction
    implements DrillAggFunc {
        @Param
        Float4Holder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (!filter.isPresent(String.valueOf(this.in.value))) {
                    filter.add(String.valueOf(this.in.value));
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBigIntCntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableBigIntHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1) {
                    if (!filter.isPresent(String.valueOf(this.in.value))) {
                        filter.add(String.valueOf(this.in.value));
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BigIntCntDupsFunction
    implements DrillAggFunc {
        @Param
        BigIntHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (!filter.isPresent(String.valueOf(this.in.value))) {
                    filter.add(String.valueOf(this.in.value));
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntCntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableIntHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1) {
                    if (!filter.isPresent(String.valueOf(this.in.value))) {
                        filter.add(String.valueOf(this.in.value));
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntCntDupsFunction
    implements DrillAggFunc {
        @Param
        IntHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (!filter.isPresent(String.valueOf(this.in.value))) {
                    filter.add(String.valueOf(this.in.value));
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBitCntDupsFunction
    implements DrillAggFunc {
        @Param
        NullableBitHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (this.in.isSet == 1) {
                    if (!filter.isPresent(String.valueOf(this.in.value))) {
                        filter.add(String.valueOf(this.in.value));
                    } else {
                        ++this.dups.value;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="approx_count_dups", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BitCntDupsFunction
    implements DrillAggFunc {
        @Param
        BitHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        BigIntHolder dups;
        @Output
        NullableBigIntHolder out;
        @Inject
        OptionManager options;
        @Workspace
        IntHolder ndvBloomFilterElts;
        @Workspace
        IntHolder ndvBloomFilterFPProb;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.dups.value = 0L;
            this.ndvBloomFilterElts.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_elements");
            this.ndvBloomFilterFPProb.value = (int)this.options.getLong("exec.statistics.ndv_extrapolation_bf_fpprobability");
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                if (!filter.isPresent(String.valueOf(this.in.value))) {
                    filter.add(String.valueOf(this.in.value));
                } else {
                    ++this.dups.value;
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                BloomFilter filter = (BloomFilter)this.work.obj;
                this.out.isSet = 1;
                this.out.value = this.dups.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.dups.value = 0L;
            this.work.obj = new BloomFilter(this.ndvBloomFilterElts.value, this.ndvBloomFilterFPProb.value);
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarBinarySumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableVarBinaryHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            if (this.in.isSet == 1) {
                this.totWidth.value += (long)StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes().length;
                ++this.nonNullCount.value;
            }
        }

        @Override
        public void output() {
            this.out.value = this.nonNullCount.value > 0L ? (double)this.totWidth.value : 0.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarBinarySumWidthFunction
    implements DrillAggFunc {
        @Param
        VarBinaryHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += (long)StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes().length;
        }

        @Override
        public void output() {
            this.out.value = this.totWidth.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVar16CharSumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableVar16CharHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            if (this.in.isSet == 1) {
                this.totWidth.value += (long)StringFunctionHelpers.toStringFromUTF16(this.in.start, this.in.end, this.in.buffer).getBytes().length;
                ++this.nonNullCount.value;
            }
        }

        @Override
        public void output() {
            this.out.value = this.nonNullCount.value > 0L ? (double)this.totWidth.value : 0.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Var16CharSumWidthFunction
    implements DrillAggFunc {
        @Param
        Var16CharHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += (long)StringFunctionHelpers.toStringFromUTF16(this.in.start, this.in.end, this.in.buffer).getBytes().length;
        }

        @Override
        public void output() {
            this.out.value = this.totWidth.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarCharSumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableVarCharHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            if (this.in.isSet == 1) {
                this.totWidth.value += (long)StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes().length;
                ++this.nonNullCount.value;
            }
        }

        @Override
        public void output() {
            this.out.value = this.nonNullCount.value > 0L ? (double)this.totWidth.value : 0.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarCharSumWidthFunction
    implements DrillAggFunc {
        @Param
        VarCharHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += (long)StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes().length;
        }

        @Override
        public void output() {
            this.out.value = this.totWidth.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntervalSumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableIntervalHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 12L;
        }

        @Override
        public void output() {
            this.out.value = this.totWidth.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntervalSumWidthFunction
    implements DrillAggFunc {
        @Param
        IntervalHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 12L;
        }

        @Override
        public void output() {
            this.out.value = this.totWidth.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTimeStampSumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableTimeStampHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TimeStampSumWidthFunction
    implements DrillAggFunc {
        @Param
        TimeStampHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTimeSumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableTimeHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TimeSumWidthFunction
    implements DrillAggFunc {
        @Param
        TimeHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDateSumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDateHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class DateSumWidthFunction
    implements DrillAggFunc {
        @Param
        DateHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat8SumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableFloat8Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float8SumWidthFunction
    implements DrillAggFunc {
        @Param
        Float8Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat4SumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableFloat4Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float4SumWidthFunction
    implements DrillAggFunc {
        @Param
        Float4Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal38SparseSumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal38SparseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 16L;
        }

        @Override
        public void output() {
            this.out.value = this.totWidth.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal38SparseSumWidthFunction
    implements DrillAggFunc {
        @Param
        Decimal38SparseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 16L;
        }

        @Override
        public void output() {
            this.out.value = this.totWidth.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal38DenseSumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal38DenseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 16L;
        }

        @Override
        public void output() {
            this.out.value = this.totWidth.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal38DenseSumWidthFunction
    implements DrillAggFunc {
        @Param
        Decimal38DenseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 16L;
        }

        @Override
        public void output() {
            this.out.value = this.totWidth.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal28SparseSumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal28SparseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 12L;
        }

        @Override
        public void output() {
            this.out.value = this.totWidth.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal28SparseSumWidthFunction
    implements DrillAggFunc {
        @Param
        Decimal28SparseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 12L;
        }

        @Override
        public void output() {
            this.out.value = this.totWidth.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal28DenseSumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal28DenseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 12L;
        }

        @Override
        public void output() {
            this.out.value = this.totWidth.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal28DenseSumWidthFunction
    implements DrillAggFunc {
        @Param
        Decimal28DenseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 12L;
        }

        @Override
        public void output() {
            this.out.value = this.totWidth.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal18SumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal18Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal18SumWidthFunction
    implements DrillAggFunc {
        @Param
        Decimal18Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal9SumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal9Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal9SumWidthFunction
    implements DrillAggFunc {
        @Param
        Decimal9Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBigIntSumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableBigIntHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BigIntSumWidthFunction
    implements DrillAggFunc {
        @Param
        BigIntHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntSumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableIntHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntSumWidthFunction
    implements DrillAggFunc {
        @Param
        IntHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBitSumWidthFunction
    implements DrillAggFunc {
        @Param
        NullableBitHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 8L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="sum_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BitSumWidthFunction
    implements DrillAggFunc {
        @Param
        BitHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 8L;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / 8.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarBinaryAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableVarBinaryHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            if (this.in.isSet == 1) {
                this.totWidth.value += (long)StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes().length;
                ++this.nonNullCount.value;
            }
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = this.nonNullCount.value > 0L ? (double)this.totWidth.value / (double)this.count.value : 0.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarBinaryAvgWidthFunction
    implements DrillAggFunc {
        @Param
        VarBinaryHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += (long)StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes().length;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / (double)this.count.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVar16CharAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableVar16CharHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            if (this.in.isSet == 1) {
                this.totWidth.value += (long)StringFunctionHelpers.toStringFromUTF16(this.in.start, this.in.end, this.in.buffer).getBytes().length;
                ++this.nonNullCount.value;
            }
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = this.nonNullCount.value > 0L ? (double)this.totWidth.value / (double)this.count.value : 0.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Var16CharAvgWidthFunction
    implements DrillAggFunc {
        @Param
        Var16CharHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += (long)StringFunctionHelpers.toStringFromUTF16(this.in.start, this.in.end, this.in.buffer).getBytes().length;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / (double)this.count.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarCharAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableVarCharHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            if (this.in.isSet == 1) {
                this.totWidth.value += (long)StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes().length;
                ++this.nonNullCount.value;
            }
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = this.nonNullCount.value > 0L ? (double)this.totWidth.value / (double)this.count.value : 0.0;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarCharAvgWidthFunction
    implements DrillAggFunc {
        @Param
        VarCharHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += (long)StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes().length;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / (double)this.count.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntervalAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableIntervalHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 12L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / (double)this.count.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntervalAvgWidthFunction
    implements DrillAggFunc {
        @Param
        IntervalHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 12L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / (double)this.count.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTimeStampAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableTimeStampHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TimeStampAvgWidthFunction
    implements DrillAggFunc {
        @Param
        TimeStampHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTimeAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableTimeHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TimeAvgWidthFunction
    implements DrillAggFunc {
        @Param
        TimeHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDateAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDateHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class DateAvgWidthFunction
    implements DrillAggFunc {
        @Param
        DateHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat8AvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableFloat8Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float8AvgWidthFunction
    implements DrillAggFunc {
        @Param
        Float8Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat4AvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableFloat4Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float4AvgWidthFunction
    implements DrillAggFunc {
        @Param
        Float4Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal38SparseAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal38SparseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 16L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / (double)this.count.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal38SparseAvgWidthFunction
    implements DrillAggFunc {
        @Param
        Decimal38SparseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 16L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / (double)this.count.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal38DenseAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal38DenseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 16L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / (double)this.count.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal38DenseAvgWidthFunction
    implements DrillAggFunc {
        @Param
        Decimal38DenseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 16L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / (double)this.count.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal28SparseAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal28SparseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 12L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / (double)this.count.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal28SparseAvgWidthFunction
    implements DrillAggFunc {
        @Param
        Decimal28SparseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 12L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / (double)this.count.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal28DenseAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal28DenseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 12L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / (double)this.count.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal28DenseAvgWidthFunction
    implements DrillAggFunc {
        @Param
        Decimal28DenseHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 12L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / (double)this.count.value;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal18AvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal18Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal18AvgWidthFunction
    implements DrillAggFunc {
        @Param
        Decimal18Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal9AvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal9Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal9AvgWidthFunction
    implements DrillAggFunc {
        @Param
        Decimal9Holder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBigIntAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableBigIntHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BigIntAvgWidthFunction
    implements DrillAggFunc {
        @Param
        BigIntHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 64L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableIntHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntAvgWidthFunction
    implements DrillAggFunc {
        @Param
        IntHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 32L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBitAvgWidthFunction
    implements DrillAggFunc {
        @Param
        NullableBitHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            this.totWidth.value += 8L;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg_width", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BitAvgWidthFunction
    implements DrillAggFunc {
        @Param
        BitHolder in;
        @Workspace
        BigIntHolder totWidth;
        @Workspace
        BigIntHolder count;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.totWidth = new BigIntHolder();
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            ++this.totWidth.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.value = (double)this.totWidth.value / ((double)this.count.value * 8.0);
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.totWidth.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarBinaryHLLFunction
    implements DrillAggFunc {
        @Param
        NullableVarBinaryHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                if (this.in.isSet == 1) {
                    byte[] buf = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes();
                    hll.offer((Object)buf);
                } else {
                    hll.offer(null);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarBinaryHLLFunction
    implements DrillAggFunc {
        @Param
        VarBinaryHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                byte[] buf = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes();
                hll.offer((Object)buf);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVar16CharHLLFunction
    implements DrillAggFunc {
        @Param
        NullableVar16CharHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                if (this.in.isSet == 1) {
                    byte[] buf = StringFunctionHelpers.toStringFromUTF16(this.in.start, this.in.end, this.in.buffer).getBytes();
                    hll.offer((Object)buf);
                } else {
                    hll.offer(null);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Var16CharHLLFunction
    implements DrillAggFunc {
        @Param
        Var16CharHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                byte[] buf = StringFunctionHelpers.toStringFromUTF16(this.in.start, this.in.end, this.in.buffer).getBytes();
                hll.offer((Object)buf);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarCharHLLFunction
    implements DrillAggFunc {
        @Param
        NullableVarCharHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                if (this.in.isSet == 1) {
                    byte[] buf = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes();
                    hll.offer((Object)buf);
                } else {
                    hll.offer(null);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarCharHLLFunction
    implements DrillAggFunc {
        @Param
        VarCharHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                byte[] buf = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes();
                hll.offer((Object)buf);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntervalHLLFunction
    implements DrillAggFunc {
        @Param
        NullableIntervalHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        ObjectHolder interval;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.interval = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
            this.interval.obj = new ArrayList(3);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                if (this.in.isSet == 1) {
                    if (this.interval.obj != null) {
                        ArrayList intervalList = (ArrayList)this.interval.obj;
                        intervalList.clear();
                        intervalList.add(this.in.days);
                        intervalList.add(this.in.months);
                        intervalList.add(this.in.milliseconds);
                        hll.offer(this.interval.obj);
                    }
                } else {
                    hll.offer(null);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
            this.interval.obj = new ArrayList(3);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntervalHLLFunction
    implements DrillAggFunc {
        @Param
        IntervalHolder in;
        @Workspace
        ObjectHolder work;
        @Workspace
        ObjectHolder interval;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.interval = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
            this.interval.obj = new ArrayList(3);
        }

        @Override
        public void add() {
            if (this.work.obj != null && this.interval.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                ArrayList intervalList = (ArrayList)this.interval.obj;
                intervalList.clear();
                intervalList.add(this.in.days);
                intervalList.add(this.in.months);
                intervalList.add(this.in.milliseconds);
                hll.offer(this.interval.obj);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
            this.interval.obj = new ArrayList(3);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTimeStampHLLFunction
    implements DrillAggFunc {
        @Param
        NullableTimeStampHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                if (this.in.isSet == 1) {
                    hll.offer((Object)this.in.value);
                } else {
                    hll.offer(null);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TimeStampHLLFunction
    implements DrillAggFunc {
        @Param
        TimeStampHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                hll.offer((Object)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTimeHLLFunction
    implements DrillAggFunc {
        @Param
        NullableTimeHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                if (this.in.isSet == 1) {
                    hll.offer((Object)this.in.value);
                } else {
                    hll.offer(null);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TimeHLLFunction
    implements DrillAggFunc {
        @Param
        TimeHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                hll.offer((Object)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDateHLLFunction
    implements DrillAggFunc {
        @Param
        NullableDateHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                if (this.in.isSet == 1) {
                    hll.offer((Object)this.in.value);
                } else {
                    hll.offer(null);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class DateHLLFunction
    implements DrillAggFunc {
        @Param
        DateHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                hll.offer((Object)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal18HLLFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal18Holder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                if (this.in.isSet == 1) {
                    hll.offer((Object)this.in.value);
                } else {
                    hll.offer(null);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal18HLLFunction
    implements DrillAggFunc {
        @Param
        Decimal18Holder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                hll.offer((Object)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDecimal9HLLFunction
    implements DrillAggFunc {
        @Param
        NullableDecimal9Holder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                if (this.in.isSet == 1) {
                    hll.offer((Object)this.in.value);
                } else {
                    hll.offer(null);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Decimal9HLLFunction
    implements DrillAggFunc {
        @Param
        Decimal9Holder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                hll.offer((Object)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat8HLLFunction
    implements DrillAggFunc {
        @Param
        NullableFloat8Holder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                if (this.in.isSet == 1) {
                    hll.offer((Object)this.in.value);
                } else {
                    hll.offer(null);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float8HLLFunction
    implements DrillAggFunc {
        @Param
        Float8Holder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                hll.offer((Object)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat4HLLFunction
    implements DrillAggFunc {
        @Param
        NullableFloat4Holder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                if (this.in.isSet == 1) {
                    hll.offer((Object)Float.valueOf(this.in.value));
                } else {
                    hll.offer(null);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float4HLLFunction
    implements DrillAggFunc {
        @Param
        Float4Holder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                hll.offer((Object)Float.valueOf(this.in.value));
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBigIntHLLFunction
    implements DrillAggFunc {
        @Param
        NullableBigIntHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                if (this.in.isSet == 1) {
                    hll.offer((Object)this.in.value);
                } else {
                    hll.offer(null);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BigIntHLLFunction
    implements DrillAggFunc {
        @Param
        BigIntHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                hll.offer((Object)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntHLLFunction
    implements DrillAggFunc {
        @Param
        NullableIntHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                if (this.in.isSet == 1) {
                    hll.offer((Object)this.in.value);
                } else {
                    hll.offer(null);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntHLLFunction
    implements DrillAggFunc {
        @Param
        IntHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                hll.offer((Object)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBitHLLFunction
    implements DrillAggFunc {
        @Param
        NullableBitHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                hll.offer((Object)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BitHLLFunction
    implements DrillAggFunc {
        @Param
        BitHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                hll.offer((Object)this.in.value);
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll_merge", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class HllMerge
    implements DrillAggFunc {
        @Param
        NullableVarBinaryHolder in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    if (this.in.isSet != 0) {
                        byte[] buf = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes();
                        HyperLogLog other = HyperLogLog.Builder.build((byte[])buf);
                        hll.addAll(other);
                    }
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Failed to merge HyperLogLog output", e);
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="hll_decode", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class HllDecode
    implements DrillSimpleFunc {
        @Param
        NullableVarBinaryHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = -1L;
            if (this.in.isSet != 0) {
                byte[] din = new byte[this.in.end - this.in.start];
                this.in.buffer.getBytes(this.in.start, din);
                try {
                    this.out.value = HyperLogLog.Builder.build((byte[])din).cardinality();
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failure evaluating hll_decode", e);
                }
            }
        }
    }

    @FunctionTemplate(name="hll", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class HllFieldReader
    implements DrillAggFunc {
        @Param
        FieldReader in;
        @Workspace
        ObjectHolder work;
        @Output
        NullableVarBinaryHolder out;
        @Inject
        OptionManager options;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder hllAccuracy;

        @Override
        public void setup() {
            this.work = new ObjectHolder();
            this.hllAccuracy.value = (int)this.options.getLong("exec.statistics.ndv_accuracy");
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }

        @Override
        public void add() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                int mode = this.in.getType().getMode().getNumber();
                int type = this.in.getType().getMinorType().getNumber();
                block0 : switch (mode) {
                    case 0: {
                        if (!this.in.isSet()) {
                            hll.offer(null);
                            break;
                        }
                    }
                    case 1: {
                        switch (type) {
                            case 24: {
                                hll.offer((Object)this.in.readText().toString());
                                break block0;
                            }
                            case 6: {
                                hll.offer((Object)this.in.readLong());
                                break block0;
                            }
                        }
                        this.work.obj = null;
                        break;
                    }
                    default: {
                        this.work.obj = null;
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.work.obj != null) {
                HyperLogLog hll = (HyperLogLog)this.work.obj;
                try {
                    byte[] ba = hll.getBytes();
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(ba.length);
                    this.out.start = 0;
                    this.out.end = ba.length;
                    this.out.buffer.setBytes(0, ba);
                    this.out.isSet = 1;
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Failed to get HyperLogLog output", e);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.work.obj = new HyperLogLog(this.hllAccuracy.value);
        }
    }

    @FunctionTemplate(name="nonnullrowcount", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NonNullRowCount
    implements DrillAggFunc {
        @Param
        FieldReader in;
        @Workspace
        BigIntHolder count;
        @Output
        NullableBigIntHolder out;

        @Override
        public void setup() {
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            if (this.in.isSet()) {
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            this.out.isSet = 1;
            this.out.value = this.count.value;
        }

        @Override
        public void reset() {
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="rowcount", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class RowCount
    implements DrillAggFunc {
        @Param
        FieldReader in;
        @Workspace
        BigIntHolder count;
        @Output
        NullableBigIntHolder out;

        @Override
        public void setup() {
            this.count = new BigIntHolder();
        }

        @Override
        public void add() {
            ++this.count.value;
        }

        @Override
        public void output() {
            this.out.isSet = 1;
            this.out.value = this.count.value;
        }

        @Override
        public void reset() {
            this.count.value = 0L;
        }
    }
}

