/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.fn.impl.RegexpUtil;
import org.apache.drill.exec.expr.fn.impl.SqlPatternComplexMatcher;
import org.apache.drill.exec.expr.fn.impl.SqlPatternConstantMatcher;
import org.apache.drill.exec.expr.fn.impl.SqlPatternContainsMatcher;
import org.apache.drill.exec.expr.fn.impl.SqlPatternEndsWithMatcher;
import org.apache.drill.exec.expr.fn.impl.SqlPatternMatcher;
import org.apache.drill.exec.expr.fn.impl.SqlPatternStartsWithMatcher;

public class SqlPatternFactory {
    public static SqlPatternMatcher getSqlPatternMatcher(RegexpUtil.SqlPatternInfo patternInfo) {
        switch (patternInfo.getPatternType()) {
            case COMPLEX: {
                return new SqlPatternComplexMatcher(patternInfo.getJavaPatternString());
            }
            case STARTS_WITH: {
                return new SqlPatternStartsWithMatcher(patternInfo.getSimplePatternString());
            }
            case CONSTANT: {
                return new SqlPatternConstantMatcher(patternInfo.getSimplePatternString());
            }
            case ENDS_WITH: {
                return new SqlPatternEndsWithMatcher(patternInfo.getSimplePatternString());
            }
            case CONTAINS: {
                return new SqlPatternContainsMatcher(patternInfo.getSimplePatternString());
            }
        }
        return null;
    }
}

