/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.fn.impl.AbstractSqlPatternMatcher;

public final class SqlPatternContainsMatcher
extends AbstractSqlPatternMatcher {
    private final MatcherFcn matcherFcn;

    public SqlPatternContainsMatcher(String patternString) {
        super(patternString);
        this.matcherFcn = this.patternLength == 0 ? new MatcherZero() : (this.patternLength == 1 ? new MatcherOne() : (this.patternLength == 2 ? new MatcherTwo() : (this.patternLength == 3 ? new MatcherThree() : (this.patternLength < 10 ? new MatcherN() : new BoyerMooreMatcher()))));
    }

    @Override
    public int match(int start, int end, DrillBuf drillBuf) {
        return this.matcherFcn.match(start, end, drillBuf);
    }

    private final class MatcherZero
    extends MatcherFcn {
        private MatcherZero() {
        }

        @Override
        protected final int match(int start, int end, DrillBuf drillBuf) {
            return 1;
        }
    }

    private abstract class MatcherFcn {
        protected final byte[] patternArray;

        protected MatcherFcn() {
            assert (SqlPatternContainsMatcher.this.patternByteBuffer.hasArray());
            this.patternArray = SqlPatternContainsMatcher.this.patternByteBuffer.array();
        }

        protected abstract int match(int var1, int var2, DrillBuf var3);
    }

    private final class MatcherOne
    extends MatcherFcn {
        final byte firstPatternByte;

        private MatcherOne() {
            this.firstPatternByte = this.patternArray[0];
        }

        @Override
        protected final int match(int start, int end, DrillBuf drillBuf) {
            int lengthToProcess = end - start;
            for (int idx = 0; idx < lengthToProcess; ++idx) {
                byte inputByte = drillBuf.getByte(start + idx);
                if (this.firstPatternByte != inputByte) continue;
                return 1;
            }
            return 0;
        }
    }

    private final class MatcherTwo
    extends MatcherFcn {
        final byte firstPatternByte;
        final byte secondPatternByte;

        private MatcherTwo() {
            this.firstPatternByte = this.patternArray[0];
            this.secondPatternByte = this.patternArray[1];
        }

        @Override
        protected final int match(int start, int end, DrillBuf drillBuf) {
            int lengthToProcess = end - start - 1;
            for (int idx = 0; idx < lengthToProcess; ++idx) {
                byte secondInByte;
                byte firstInByte = drillBuf.getByte(start + idx);
                if (this.firstPatternByte != firstInByte || (secondInByte = drillBuf.getByte(start + idx + 1)) != this.secondPatternByte) continue;
                return 1;
            }
            return 0;
        }
    }

    private final class MatcherThree
    extends MatcherFcn {
        final byte firstPatternByte;
        final byte secondPatternByte;
        final byte thirdPatternByte;

        private MatcherThree() {
            this.firstPatternByte = this.patternArray[0];
            this.secondPatternByte = this.patternArray[1];
            this.thirdPatternByte = this.patternArray[2];
        }

        @Override
        protected final int match(int start, int end, DrillBuf drillBuf) {
            int lengthToProcess = end - start - 2;
            for (int idx = 0; idx < lengthToProcess; ++idx) {
                byte inputByte = drillBuf.getByte(start + idx);
                if (this.firstPatternByte != inputByte) continue;
                byte secondInByte = drillBuf.getByte(start + idx + 1);
                byte thirdInByte = drillBuf.getByte(start + idx + 2);
                if (secondInByte != this.secondPatternByte || thirdInByte != this.thirdPatternByte) continue;
                return 1;
            }
            return 0;
        }
    }

    private final class MatcherN
    extends MatcherFcn {
        final byte firstPatternByte;

        private MatcherN() {
            this.firstPatternByte = this.patternArray[0];
        }

        @Override
        protected final int match(int start, int end, DrillBuf drillBuf) {
            int lengthToProcess = end - start - SqlPatternContainsMatcher.this.patternLength + 1;
            int patternIndex = 0;
            for (int idx = 0; idx < lengthToProcess; ++idx) {
                byte currPattByte;
                byte currInByte;
                byte inputByte = drillBuf.getByte(start + idx);
                if (this.firstPatternByte != inputByte) continue;
                for (patternIndex = 1; patternIndex < SqlPatternContainsMatcher.this.patternLength && (currInByte = drillBuf.getByte(start + idx + patternIndex)) == (currPattByte = this.patternArray[patternIndex]); ++patternIndex) {
                }
                if (patternIndex != SqlPatternContainsMatcher.this.patternLength) continue;
                return 1;
            }
            return 0;
        }
    }

    private final class BoyerMooreMatcher
    extends MatcherFcn {
        private final int[] offsetTable = this.makeOffsetTable();
        private final int[] characterTable = this.makeCharTable();

        private BoyerMooreMatcher() {
        }

        @Override
        protected int match(int start, int end, DrillBuf drillBuf) {
            int idx2;
            int inputLength = end - start;
            for (int idx1 = SqlPatternContainsMatcher.this.patternLength - 1; idx1 < inputLength; idx1 += Math.max(this.offsetTable[SqlPatternContainsMatcher.this.patternLength - 1 - idx2], this.characterTable[drillBuf.getByte(start + idx1) & 0xFF])) {
                idx2 = SqlPatternContainsMatcher.this.patternLength - 1;
                while (this.patternArray[idx2] == drillBuf.getByte(start + idx1)) {
                    if (idx2 == 0) {
                        return 1;
                    }
                    --idx1;
                    --idx2;
                }
            }
            return 0;
        }

        private int[] makeCharTable() {
            int idx;
            int TABLE_SIZE = 256;
            int[] resultTable = new int[256];
            for (idx = 0; idx < resultTable.length; ++idx) {
                resultTable[idx] = SqlPatternContainsMatcher.this.patternLength;
            }
            for (idx = 0; idx < SqlPatternContainsMatcher.this.patternLength - 1; ++idx) {
                int patternValue = this.patternArray[idx] & 0xFF;
                resultTable[patternValue] = SqlPatternContainsMatcher.this.patternLength - 1 - idx;
            }
            return resultTable;
        }

        private int[] makeOffsetTable() {
            int idx;
            int[] resultTable = new int[SqlPatternContainsMatcher.this.patternLength];
            int lastPrefixPosition = SqlPatternContainsMatcher.this.patternLength;
            for (idx = SqlPatternContainsMatcher.this.patternLength - 1; idx >= 0; --idx) {
                if (this.isPrefix(idx + 1)) {
                    lastPrefixPosition = idx + 1;
                }
                resultTable[SqlPatternContainsMatcher.this.patternLength - 1 - idx] = lastPrefixPosition - idx + SqlPatternContainsMatcher.this.patternLength - 1;
            }
            for (idx = 0; idx < SqlPatternContainsMatcher.this.patternLength - 1; ++idx) {
                int suffixLen = this.suffixLength(idx);
                resultTable[suffixLen] = SqlPatternContainsMatcher.this.patternLength - 1 - idx + suffixLen;
            }
            return resultTable;
        }

        private boolean isPrefix(int pos) {
            int idx1 = pos;
            int idx2 = 0;
            while (idx1 < SqlPatternContainsMatcher.this.patternLength) {
                if (this.patternArray[idx1] != this.patternArray[idx2]) {
                    return false;
                }
                ++idx1;
                ++idx2;
            }
            return true;
        }

        private int suffixLength(int pos) {
            int result = 0;
            int idx1 = pos;
            int idx2 = SqlPatternContainsMatcher.this.patternLength - 1;
            while (idx1 >= 0 && this.patternArray[idx1] == this.patternArray[idx2]) {
                ++result;
                --idx1;
                --idx2;
            }
            return result;
        }
    }
}

