/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

public class RegexpUtil {
    private static final String JAVA_REGEX_SPECIALS = "[]()|^-+*?{}$\\.";
    private static final String SQL_SIMILAR_SPECIALS = "[]()|^-+*_%?{}";
    private static final String[] REG_CHAR_CLASSES = new String[]{"[:ALPHA:]", "\\p{Alpha}", "[:alpha:]", "\\p{Alpha}", "[:UPPER:]", "\\p{Upper}", "[:upper:]", "\\p{Upper}", "[:LOWER:]", "\\p{Lower}", "[:lower:]", "\\p{Lower}", "[:DIGIT:]", "\\d", "[:digit:]", "\\d", "[:SPACE:]", " ", "[:space:]", " ", "[:WHITESPACE:]", "\\s", "[:whitespace:]", "\\s", "[:ALNUM:]", "\\p{Alnum}", "[:alnum:]", "\\p{Alnum}"};

    public static SqlPatternInfo sqlToRegexLike(String sqlPattern) {
        return RegexpUtil.sqlToRegexLike(sqlPattern, '\u0000');
    }

    public static SqlPatternInfo sqlToRegexLike(String sqlPattern, CharSequence escapeStr) {
        char escapeChar;
        if (escapeStr != null) {
            if (escapeStr.length() != 1) {
                throw RegexpUtil.invalidEscapeCharacter(escapeStr.toString());
            }
            escapeChar = escapeStr.charAt(0);
        } else {
            escapeChar = '\u0000';
        }
        return RegexpUtil.sqlToRegexLike(sqlPattern, escapeChar);
    }

    public static SqlPatternInfo sqlToRegexLike(String sqlPattern, char escapeChar) {
        int len = sqlPattern.length();
        StringBuilder javaPattern = new StringBuilder(len + len);
        StringBuilder simplePattern = new StringBuilder(len);
        SqlPatternType patternType = SqlPatternType.CONSTANT;
        for (int i = 0; i < len; ++i) {
            char c = sqlPattern.charAt(i);
            if (JAVA_REGEX_SPECIALS.indexOf(c) >= 0) {
                javaPattern.append('\\');
            }
            if (c == escapeChar) {
                if (i == sqlPattern.length() - 1) {
                    throw RegexpUtil.invalidEscapeSequence(sqlPattern, i);
                }
                char nextChar = sqlPattern.charAt(i + 1);
                if (nextChar == '_' || nextChar == '%' || nextChar == escapeChar) {
                    javaPattern.append(nextChar);
                    simplePattern.append(nextChar);
                    ++i;
                    continue;
                }
                throw RegexpUtil.invalidEscapeSequence(sqlPattern, i);
            }
            if (c == '_') {
                patternType = SqlPatternType.COMPLEX;
                javaPattern.append('.');
                continue;
            }
            if (c == '%') {
                if (i == 0) {
                    patternType = SqlPatternType.ENDS_WITH;
                } else if (i == len - 1) {
                    if (patternType == SqlPatternType.ENDS_WITH) {
                        patternType = SqlPatternType.CONTAINS;
                    } else if (patternType == SqlPatternType.CONSTANT) {
                        patternType = SqlPatternType.STARTS_WITH;
                    }
                } else {
                    patternType = SqlPatternType.COMPLEX;
                }
                javaPattern.append(".");
                javaPattern.append('*');
                continue;
            }
            javaPattern.append(c);
            simplePattern.append(c);
        }
        return new SqlPatternInfo(patternType, javaPattern.toString(), simplePattern.toString());
    }

    private static RuntimeException invalidEscapeCharacter(String s) {
        return new RuntimeException("Invalid escape character '" + s + "'");
    }

    private static RuntimeException invalidEscapeSequence(String s, int i) {
        return new RuntimeException("Invalid escape sequence '" + s + "', " + i);
    }

    private static void similarEscapeRuleChecking(String sqlPattern, char escapeChar) {
        if (escapeChar == '\u0000') {
            return;
        }
        if (SQL_SIMILAR_SPECIALS.indexOf(escapeChar) >= 0) {
            for (int i = 0; i < sqlPattern.length(); ++i) {
                if (sqlPattern.charAt(i) != escapeChar) continue;
                if (i == sqlPattern.length() - 1) {
                    throw RegexpUtil.invalidEscapeSequence(sqlPattern, i);
                }
                char c = sqlPattern.charAt(i + 1);
                if (SQL_SIMILAR_SPECIALS.indexOf(c) >= 0 || c == escapeChar) continue;
                throw RegexpUtil.invalidEscapeSequence(sqlPattern, i);
            }
        }
        if (escapeChar == ':') {
            int position = sqlPattern.indexOf("[:");
            if (position >= 0) {
                position = sqlPattern.indexOf(":]");
            }
            if (position < 0) {
                throw RegexpUtil.invalidEscapeSequence(sqlPattern, position);
            }
        }
    }

    private static RuntimeException invalidRegularExpression(String pattern, int i) {
        return new RuntimeException("Invalid regular expression '" + pattern + "'");
    }

    private static int sqlSimilarRewriteCharEnumeration(String sqlPattern, StringBuilder javaPattern, int pos, char escapeChar) {
        int i;
        for (i = pos + 1; i < sqlPattern.length(); ++i) {
            char c = sqlPattern.charAt(i);
            if (c == ']') {
                return i - 1;
            }
            if (c == escapeChar) {
                char nextChar;
                if (SQL_SIMILAR_SPECIALS.indexOf(nextChar = sqlPattern.charAt(++i)) >= 0) {
                    if (JAVA_REGEX_SPECIALS.indexOf(nextChar) >= 0) {
                        javaPattern.append('\\');
                    }
                    javaPattern.append(nextChar);
                    continue;
                }
                if (escapeChar == nextChar) {
                    javaPattern.append(nextChar);
                    continue;
                }
                throw RegexpUtil.invalidRegularExpression(sqlPattern, i);
            }
            if (c == '-') {
                javaPattern.append('-');
                continue;
            }
            if (c == '^') {
                javaPattern.append('^');
                continue;
            }
            if (sqlPattern.startsWith("[:", i)) {
                int numOfRegCharSets = REG_CHAR_CLASSES.length / 2;
                boolean found = false;
                for (int j = 0; j < numOfRegCharSets; ++j) {
                    if (!sqlPattern.startsWith(REG_CHAR_CLASSES[j + j], i)) continue;
                    javaPattern.append(REG_CHAR_CLASSES[j + j + 1]);
                    i += REG_CHAR_CLASSES[j + j].length() - 1;
                    found = true;
                    break;
                }
                if (found) continue;
                throw RegexpUtil.invalidRegularExpression(sqlPattern, i);
            }
            if (SQL_SIMILAR_SPECIALS.indexOf(c) >= 0) {
                throw RegexpUtil.invalidRegularExpression(sqlPattern, i);
            }
            javaPattern.append(c);
        }
        return i - 1;
    }

    public static String sqlToRegexSimilar(String sqlPattern) {
        return RegexpUtil.sqlToRegexSimilar(sqlPattern, '\u0000');
    }

    public static String sqlToRegexSimilar(String sqlPattern, CharSequence escapeStr) {
        char escapeChar;
        if (escapeStr != null) {
            if (escapeStr.length() != 1) {
                throw RegexpUtil.invalidEscapeCharacter(escapeStr.toString());
            }
            escapeChar = escapeStr.charAt(0);
        } else {
            escapeChar = '\u0000';
        }
        return RegexpUtil.sqlToRegexSimilar(sqlPattern, escapeChar);
    }

    public static String sqlToRegexSimilar(String sqlPattern, char escapeChar) {
        RegexpUtil.similarEscapeRuleChecking(sqlPattern, escapeChar);
        boolean insideCharacterEnumeration = false;
        StringBuilder javaPattern = new StringBuilder(sqlPattern.length() * 2);
        int len = sqlPattern.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = sqlPattern.charAt(i);
            if (c == escapeChar) {
                if (i == len - 1) {
                    throw RegexpUtil.invalidEscapeSequence(sqlPattern, i);
                }
                char nextChar = sqlPattern.charAt(i + 1);
                if (SQL_SIMILAR_SPECIALS.indexOf(nextChar) >= 0) {
                    if (JAVA_REGEX_SPECIALS.indexOf(nextChar) >= 0) {
                        javaPattern.append('\\');
                    }
                    javaPattern.append(nextChar);
                } else if (nextChar == escapeChar) {
                    javaPattern.append(nextChar);
                } else {
                    throw RegexpUtil.invalidEscapeSequence(sqlPattern, i);
                }
                ++i;
                continue;
            }
            switch (c) {
                case '_': {
                    javaPattern.append('.');
                    continue block8;
                }
                case '%': {
                    javaPattern.append('.');
                    javaPattern.append('*');
                    continue block8;
                }
                case '[': {
                    javaPattern.append('[');
                    insideCharacterEnumeration = true;
                    i = RegexpUtil.sqlSimilarRewriteCharEnumeration(sqlPattern, javaPattern, i, escapeChar);
                    continue block8;
                }
                case ']': {
                    if (!insideCharacterEnumeration) {
                        throw RegexpUtil.invalidRegularExpression(sqlPattern, i);
                    }
                    insideCharacterEnumeration = false;
                    javaPattern.append(']');
                    continue block8;
                }
                case '\\': {
                    javaPattern.append("\\\\");
                    continue block8;
                }
                case '$': {
                    javaPattern.append("\\$");
                    continue block8;
                }
                default: {
                    javaPattern.append(c);
                }
            }
        }
        if (insideCharacterEnumeration) {
            throw RegexpUtil.invalidRegularExpression(sqlPattern, len);
        }
        return javaPattern.toString();
    }

    public static class SqlPatternInfo {
        private final SqlPatternType patternType;
        private final String simplePatternString;
        private final String javaPatternString;

        public SqlPatternInfo(SqlPatternType patternType, String javaPatternString, String simplePatternString) {
            this.patternType = patternType;
            this.simplePatternString = simplePatternString;
            this.javaPatternString = javaPatternString;
        }

        public SqlPatternType getPatternType() {
            return this.patternType;
        }

        public String getSimplePatternString() {
            return this.simplePatternString;
        }

        public String getJavaPatternString() {
            return this.javaPatternString;
        }
    }

    public static enum SqlPatternType {
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS,
        CONSTANT,
        COMPLEX;

    }
}

