/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;

public class ParseUrlFunction {

    @FunctionTemplate(name="parse_url", scope=FunctionTemplate.FunctionScope.SIMPLE)
    public static class ParseUrlNullableInput
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder in;
        @Output
        BaseWriter.ComplexWriter outWriter;
        @Inject
        DrillBuf outBuffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BaseWriter.MapWriter mapWriter = this.outWriter.rootAsMap();
            if (this.in.isSet == 0) {
                mapWriter.start();
                mapWriter.end();
                return;
            }
            String urlString = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer);
            try {
                mapWriter.start();
                URL aURL = new URL(urlString);
                LinkedHashMap<String, String> urlComponents = new LinkedHashMap<String, String>();
                urlComponents.put("protocol", aURL.getProtocol());
                urlComponents.put("authority", aURL.getAuthority());
                urlComponents.put("host", aURL.getHost());
                urlComponents.put("path", aURL.getPath());
                urlComponents.put("query", aURL.getQuery());
                urlComponents.put("filename", aURL.getFile());
                urlComponents.put("ref", aURL.getRef());
                VarCharHolder rowHolder = new VarCharHolder();
                for (Map.Entry entry : urlComponents.entrySet()) {
                    if (entry.getValue() == null) continue;
                    byte[] protocolBytes = ((String)entry.getValue()).getBytes(StandardCharsets.UTF_8);
                    this.outBuffer = this.outBuffer.reallocIfNeeded(protocolBytes.length);
                    this.outBuffer.setBytes(0, protocolBytes);
                    rowHolder.start = 0;
                    rowHolder.end = protocolBytes.length;
                    rowHolder.buffer = this.outBuffer;
                    mapWriter.varChar((String)entry.getKey()).write(rowHolder);
                }
                Integer port = aURL.getPort();
                if (port != -1) {
                    IntHolder intHolder = new IntHolder();
                    intHolder.value = port;
                    mapWriter.integer("port").write(intHolder);
                }
                mapWriter.end();
            }
            catch (Exception e) {
                mapWriter.end();
            }
        }
    }

    @FunctionTemplate(name="parse_url", scope=FunctionTemplate.FunctionScope.SIMPLE)
    public static class ParseUrl
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Output
        BaseWriter.ComplexWriter outWriter;
        @Inject
        DrillBuf outBuffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BaseWriter.MapWriter mapWriter = this.outWriter.rootAsMap();
            String urlString = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer);
            try {
                mapWriter.start();
                URL aURL = new URL(urlString);
                LinkedHashMap<String, String> urlComponents = new LinkedHashMap<String, String>();
                urlComponents.put("protocol", aURL.getProtocol());
                urlComponents.put("authority", aURL.getAuthority());
                urlComponents.put("host", aURL.getHost());
                urlComponents.put("path", aURL.getPath());
                urlComponents.put("query", aURL.getQuery());
                urlComponents.put("filename", aURL.getFile());
                urlComponents.put("ref", aURL.getRef());
                VarCharHolder rowHolder = new VarCharHolder();
                for (Map.Entry entry : urlComponents.entrySet()) {
                    if (entry.getValue() == null) continue;
                    byte[] protocolBytes = ((String)entry.getValue()).getBytes(StandardCharsets.UTF_8);
                    this.outBuffer = this.outBuffer.reallocIfNeeded(protocolBytes.length);
                    this.outBuffer.setBytes(0, protocolBytes);
                    rowHolder.start = 0;
                    rowHolder.end = protocolBytes.length;
                    rowHolder.buffer = this.outBuffer;
                    mapWriter.varChar((String)entry.getKey()).write(rowHolder);
                }
                Integer port = aURL.getPort();
                if (port != -1) {
                    IntHolder intHolder = new IntHolder();
                    intHolder.value = port;
                    mapWriter.integer("port").write(intHolder);
                }
                mapWriter.end();
            }
            catch (Exception e) {
                mapWriter.end();
            }
        }
    }
}

