/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;

public class ParseQueryFunction {

    @FunctionTemplate(name="parse_query", scope=FunctionTemplate.FunctionScope.SIMPLE)
    public static class ParseQueryNullableInput
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder in;
        @Output
        BaseWriter.ComplexWriter outWriter;
        @Inject
        DrillBuf outBuffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            char firstLetter;
            BaseWriter.MapWriter mapWriter = this.outWriter.rootAsMap();
            if (this.in.isSet == 0) {
                mapWriter.start();
                mapWriter.end();
                return;
            }
            String queryString = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer);
            int questionMarkIndex = queryString.indexOf("?");
            if (questionMarkIndex > -1) {
                queryString = queryString.substring(questionMarkIndex + 1);
            }
            if (queryString.trim().isEmpty() || queryString.equalsIgnoreCase("null")) {
                queryString = "";
            }
            if (!queryString.isEmpty() && (firstLetter = queryString.charAt(0)) == '&') {
                queryString = queryString.substring(1);
            }
            String[] queryParameters = queryString.split("&");
            mapWriter.start();
            for (String parameter : queryParameters) {
                String[] keyValue = parameter.split("=", 2);
                if (keyValue.length != 2) continue;
                byte[] valueBytes = keyValue[1].getBytes(StandardCharsets.UTF_8);
                this.outBuffer = this.outBuffer.reallocIfNeeded(valueBytes.length);
                this.outBuffer.setBytes(0, valueBytes);
                VarCharHolder valueHolder = new VarCharHolder();
                valueHolder.start = 0;
                valueHolder.end = valueBytes.length;
                valueHolder.buffer = this.outBuffer;
                mapWriter.varChar(keyValue[0]).write(valueHolder);
            }
            mapWriter.end();
        }
    }

    @FunctionTemplate(name="parse_query", scope=FunctionTemplate.FunctionScope.SIMPLE)
    public static class ParseQuery
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Output
        BaseWriter.ComplexWriter outWriter;
        @Inject
        DrillBuf outBuffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            char firstLetter;
            BaseWriter.MapWriter mapWriter = this.outWriter.rootAsMap();
            String queryString = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer);
            int questionMarkIndex = queryString.indexOf("?");
            if (questionMarkIndex > -1) {
                queryString = queryString.substring(questionMarkIndex + 1);
            }
            if (queryString.trim().isEmpty() || queryString.equalsIgnoreCase("null")) {
                queryString = "";
            }
            if (!queryString.isEmpty() && (firstLetter = queryString.charAt(0)) == '&') {
                queryString = queryString.substring(1);
            }
            String[] queryParameters = queryString.split("&");
            mapWriter.start();
            for (String parameter : queryParameters) {
                String[] keyValue = parameter.split("=", 2);
                if (keyValue.length != 2) continue;
                byte[] valueBytes = keyValue[1].getBytes(StandardCharsets.UTF_8);
                this.outBuffer = this.outBuffer.reallocIfNeeded(valueBytes.length);
                this.outBuffer.setBytes(0, valueBytes);
                VarCharHolder valueHolder = new VarCharHolder();
                valueHolder.start = 0;
                valueHolder.end = valueBytes.length;
                valueHolder.buffer = this.outBuffer;
                mapWriter.varChar(keyValue[0]).write(valueHolder);
            }
            mapWriter.end();
        }
    }
}

