/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import io.netty.util.internal.PlatformDependent;
import org.apache.drill.exec.expr.fn.impl.DrillHash;

public final class MurmurHash3
extends DrillHash {
    public static final long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static long murmur3_64(long bStart, long bEnd, DrillBuf buffer, int seed) {
        long h1 = (long)seed & 0xFFFFFFFFL;
        long h2 = (long)seed & 0xFFFFFFFFL;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        long start = buffer.memoryAddress() + bStart;
        long end = buffer.memoryAddress() + bEnd;
        long length = bEnd - bStart;
        long roundedEnd = start + (length & 0xFFFFFFFFFFFFFFF0L);
        for (long i = start; i < roundedEnd; i += 16L) {
            long k1 = MurmurHash3.getLongLittleEndian(i);
            long k2 = MurmurHash3.getLongLittleEndian(i + 8L);
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        long k1 = 0L;
        long k2 = 0L;
        switch ((int)length & 0xF) {
            case 15: {
                k2 = ((long)PlatformDependent.getByte(roundedEnd + 14L) & 0xFFL) << 48;
            }
            case 14: {
                k2 ^= ((long)PlatformDependent.getByte(roundedEnd + 13L) & 0xFFL) << 40;
            }
            case 13: {
                k2 ^= ((long)PlatformDependent.getByte(roundedEnd + 12L) & 0xFFL) << 32;
            }
            case 12: {
                k2 ^= ((long)PlatformDependent.getByte(roundedEnd + 11L) & 0xFFL) << 24;
            }
            case 11: {
                k2 ^= ((long)PlatformDependent.getByte(roundedEnd + 10L) & 0xFFL) << 16;
            }
            case 10: {
                k2 ^= ((long)PlatformDependent.getByte(roundedEnd + 9L) & 0xFFL) << 8;
            }
            case 9: {
                k2 ^= (long)PlatformDependent.getByte(roundedEnd + 8L) & 0xFFL;
                k2 *= 5545529020109919103L;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
            }
            case 8: {
                k1 = (long)PlatformDependent.getByte(roundedEnd + 7L) << 56;
            }
            case 7: {
                k1 ^= ((long)PlatformDependent.getByte(roundedEnd + 6L) & 0xFFL) << 48;
            }
            case 6: {
                k1 ^= ((long)PlatformDependent.getByte(roundedEnd + 5L) & 0xFFL) << 40;
            }
            case 5: {
                k1 ^= ((long)PlatformDependent.getByte(roundedEnd + 4L) & 0xFFL) << 32;
            }
            case 4: {
                k1 ^= ((long)PlatformDependent.getByte(roundedEnd + 3L) & 0xFFL) << 24;
            }
            case 3: {
                k1 ^= ((long)PlatformDependent.getByte(roundedEnd + 2L) & 0xFFL) << 16;
            }
            case 2: {
                k1 ^= ((long)PlatformDependent.getByte(roundedEnd + 1L) & 0xFFL) << 8;
            }
            case 1: {
                k1 ^= (long)PlatformDependent.getByte(roundedEnd) & 0xFFL;
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
            }
        }
        h1 ^= length;
        h1 += (h2 ^= length);
        h2 += h1;
        h1 = MurmurHash3.fmix64(h1);
        h2 = MurmurHash3.fmix64(h2);
        h1 += h2;
        h2 += h1;
        return h1;
    }

    public static long murmur3_64(long val, int seed) {
        long h1 = (long)seed & 0xFFFFFFFFL;
        long h2 = (long)seed & 0xFFFFFFFFL;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        int length = 8;
        long k1 = 0L;
        k1 = val;
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        h1 ^= (k1 *= 5545529020109919103L);
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = MurmurHash3.fmix64(h1);
        h2 = MurmurHash3.fmix64(h2);
        return h1 += h2;
    }

    public static int murmur3_32(int bStart, int bEnd, DrillBuf buffer, int seed) {
        long c1 = 3432918353L;
        long c2 = 461845907L;
        long start = buffer.memoryAddress() + (long)bStart;
        long length = bEnd - bStart;
        long UINT_MASK = 0xFFFFFFFFL;
        long lh1 = seed;
        long roundedEnd = start + (length & 0xFFFFFFFFFFFFFFFCL);
        for (long i = start; i < roundedEnd; i += 4L) {
            long lk1 = PlatformDependent.getByte(i) & 0xFF | (PlatformDependent.getByte(i + 1L) & 0xFF) << 8 | (PlatformDependent.getByte(i + 2L) & 0xFF) << 16 | PlatformDependent.getByte(i + 3L) << 24;
            lk1 *= 3432918353L;
            lk1 &= UINT_MASK;
            lk1 = lk1 << 15 & UINT_MASK | lk1 >>> 17;
            lk1 *= 461845907L;
            lh1 ^= (lk1 &= UINT_MASK);
            lh1 = lh1 << 13 & UINT_MASK | lh1 >>> 19;
            lh1 = lh1 * 5L + 3864292196L;
            lh1 = UINT_MASK & lh1;
        }
        long lk1 = 0L;
        switch ((byte)length & 3) {
            case 3: {
                lk1 = (PlatformDependent.getByte(roundedEnd + 2L) & 0xFF) << 16;
            }
            case 2: {
                lk1 |= (long)((PlatformDependent.getByte(roundedEnd + 1L) & 0xFF) << 8);
            }
            case 1: {
                lk1 |= (long)(PlatformDependent.getByte(roundedEnd) & 0xFF);
                lk1 *= 3432918353L;
                lk1 = UINT_MASK & lk1;
                lk1 = lk1 << 15 & UINT_MASK | lk1 >>> 17;
                lk1 *= 461845907L;
                lh1 ^= (lk1 &= UINT_MASK);
            }
        }
        lh1 ^= length;
        lh1 ^= lh1 >>> 16;
        lh1 *= -2048144789L;
        lh1 = UINT_MASK & lh1;
        lh1 ^= lh1 >>> 13;
        lh1 *= -1028477387L;
        lh1 = UINT_MASK & lh1;
        lh1 ^= lh1 >>> 16;
        return (int)(lh1 & UINT_MASK);
    }

    public static int murmur3_32(long val, int seed) {
        long c1 = 3432918353L;
        long c2 = 461845907L;
        long length = 8L;
        long UINT_MASK = 0xFFFFFFFFL;
        long lh1 = (long)seed & UINT_MASK;
        for (int i = 0; i < 2; ++i) {
            long lk1 = val >> i * 32 & UINT_MASK;
            lk1 *= 3432918353L;
            lk1 &= UINT_MASK;
            lk1 = lk1 << 15 & UINT_MASK | lk1 >>> 17;
            lk1 *= 461845907L;
            lh1 ^= (lk1 &= UINT_MASK);
            lh1 = lh1 << 13 & UINT_MASK | lh1 >>> 19;
            lh1 = lh1 * 5L + 3864292196L;
            lh1 = UINT_MASK & lh1;
        }
        lh1 ^= length;
        lh1 ^= lh1 >>> 16;
        lh1 *= 2246822507L;
        lh1 = UINT_MASK & lh1;
        lh1 ^= lh1 >>> 13;
        lh1 *= 3266489909L;
        lh1 = UINT_MASK & lh1;
        lh1 ^= lh1 >>> 16;
        return (int)lh1;
    }

    public static long hash64(double val, long seed) {
        return MurmurHash3.murmur3_64(Double.doubleToLongBits(val), (int)seed);
    }

    public static long hash64(long start, long end, DrillBuf buffer, long seed) {
        return MurmurHash3.murmur3_64(start, end, buffer, (int)seed);
    }

    public static int hash32(double val, long seed) {
        return MurmurHash3.murmur3_32(Double.doubleToLongBits(val), (int)seed);
    }

    public static int hash32(int start, int end, DrillBuf buffer, int seed) {
        return MurmurHash3.murmur3_32(start, end, buffer, seed);
    }
}

