/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;

@FunctionTemplate(names={"last_day"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class LastDayFunction
implements DrillSimpleFunc {
    @Param
    TimeStampHolder in;
    @Output
    DateHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        LocalDate date = Instant.ofEpochMilli(this.in.value).atZone(ZoneOffset.UTC).toLocalDate();
        LocalDate end = date.withDayOfMonth(date.lengthOfMonth());
        this.out.value = end.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
    }
}

