/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;

public class IntervalYearBigIntFunctions {

    @FunctionTemplate(names={"divide", "div"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalYearBigIntDivideFunction
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder left;
        @Param
        BigIntHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            double fractionalMonths = 0.0;
            double fractionalDays = 0.0;
            double fractionalMillis = 0.0;
            fractionalMonths = (double)this.left.value / (double)this.right.value;
            this.out.months = (int)fractionalMonths;
            fractionalMonths -= (double)((long)fractionalMonths);
            this.out.days = (int)(fractionalDays += fractionalMonths * 30.0);
            fractionalDays -= (double)((long)fractionalDays);
            this.out.milliseconds = (int)(fractionalMillis += fractionalDays * 8.64E7);
        }
    }

    @FunctionTemplate(name="multiply", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class BigIntIntervalYearMultiplyFunction
    implements DrillSimpleFunc {
        @Param
        BigIntHolder right;
        @Param
        IntervalYearHolder left;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.months = (int)((long)this.left.value * this.right.value);
        }
    }

    @FunctionTemplate(name="multiply", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalYearBigIntMultiplyFunction
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder left;
        @Param
        BigIntHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.months = (int)((long)this.left.value * this.right.value);
        }
    }
}

