/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;

public class IntervalDayFunctions {

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalDayNegateFunction
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Output
        IntervalDayHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.days = -this.left.days;
            this.out.milliseconds = -this.left.milliseconds;
        }
    }

    @FunctionTemplate(name="subtract", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalDaySubtractFunction
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.days = this.left.days - this.right.days;
            this.out.milliseconds = this.left.milliseconds - this.right.milliseconds;
            int daysFromMillis = this.out.milliseconds / 86400000;
            if (daysFromMillis != 0) {
                this.out.milliseconds -= 86400000 * daysFromMillis;
                this.out.days -= Math.abs(daysFromMillis);
            }
            if (this.out.milliseconds < 0 && this.out.days > 0) {
                --this.out.days;
                this.out.milliseconds = 86400000 + this.out.milliseconds;
            }
        }
    }

    @FunctionTemplate(name="add", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalDayAddFunction
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.days = this.left.days + this.right.days;
            long millis = (long)this.left.milliseconds + (long)this.right.milliseconds;
            if (millis >= 86400000L) {
                int daysFromMillis = (int)(millis / 86400000L);
                millis -= (long)(daysFromMillis * 86400000);
                this.out.days += daysFromMillis;
            }
            this.out.milliseconds = (int)millis;
        }
    }
}

