/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.HashHelper;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;

public class Hash64FunctionsWithSeed {

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class BitHash
    implements DrillSimpleFunc {
        @Param
        BitHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableBitHash
    implements DrillSimpleFunc {
        @Param
        NullableBitHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableVarDecimalHash
    implements DrillSimpleFunc {
        @Param
        NullableVarDecimalHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64(this.in.start, this.in.start + 20, this.in.buffer, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class VarDecimalHash
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.start, this.in.start + 20, this.in.buffer, this.seed.value);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableTimeHash
    implements DrillSimpleFunc {
        @Param
        NullableTimeHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class TimeHash
    implements DrillSimpleFunc {
        @Param
        TimeHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableTimeStampHash
    implements DrillSimpleFunc {
        @Param
        NullableTimeStampHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class TimeStampHash
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableDateHash
    implements DrillSimpleFunc {
        @Param
        NullableDateHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class DateHash
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class IntHash
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class BigIntHash
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class Var16CharHash
    implements DrillSimpleFunc {
        @Param
        Var16CharHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, this.seed.value);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class VarCharHash
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, this.seed.value);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class VarBinaryHash
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableIntHash
    implements DrillSimpleFunc {
        @Param
        NullableIntHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableBigIntHash
    implements DrillSimpleFunc {
        @Param
        NullableBigIntHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableVar16CharHash
    implements DrillSimpleFunc {
        @Param
        NullableVar16CharHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, this.seed.value);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableVarCharHash
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, this.seed.value);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableVarBinaryHash
    implements DrillSimpleFunc {
        @Param
        NullableVarBinaryHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class DoubleHash
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableDoubleHash
    implements DrillSimpleFunc {
        @Param
        NullableFloat8Holder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class FloatHash
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableFloatHash
    implements DrillSimpleFunc {
        @Param
        NullableFloat4Holder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64(this.in.value, this.seed.value);
        }
    }
}

